/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.API.UpdateSet;
import au.com.aemo.Common.Authentication.AuthenticationManager;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidatorTypeJSON;
import au.com.aemo.Common.Web.WebPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/authentication/roles")
public class WebAPIAuthenticationRoles {
    private static Logger logger = LoggerFactory.getLogger(WebAPIAuthenticationRoles.class);

    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getRoles() {
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        String string = JsonUtilities.listToJson(authenticationManager.getRoles());
        return string;
    }

    @WebPOST(AdminAccessOnly=true, Action=AuthorisationActionEnum.WRITE)
    @WebContent(value=WebContent.MediaType.TEXT_PLAIN)
    public String createRole(@WebParam(source="_body", mandatory=true, validator=WebParamValidatorTypeJSON.class) UpdateSet updateSet) throws Exception {
        Object object = null;
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        try {
            authenticationManager.updateRoles(updateSet.Roles);
            object = "Successfully updated roles";
        }
        catch (Exception exception) {
            object = "Failed to update roles: " + exception.getMessage();
        }
        return object;
    }
}

