/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Authentication;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;

@XStreamAlias(value="Authentication")
@SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Configuration class consumed by trusted code, encapsulation of properties is not really required")
public class AuthenticationConfig {
    public String IdentityProvider;
    public String AuthorisationProvider;
    public String AdminRole;
    public String DbSchema;
    public String DbTableUsers;
    public String DbTableRoles;
    public String DbTableUserGrants;
    public int CacheExpiryTimeMins;
    public String PasswordEncryptionKey;
    public Integer MaxTokenLifeMins;
    public Integer TokenExpiryMins;
    public Integer TokenEvictionCycleMins;
    public String ActiveDirectoryDomainName;
    public String PasswordValidationRegex;
    public Integer PasswordExpiryDays;
    public Integer PasswordExpiryWarningDays;

    public AuthenticationConfig() {
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        if (this.AdminRole == null) {
            this.AdminRole = "PDR_ADMIN";
        }
        if (this.DbTableUsers == null) {
            this.DbTableUsers = "PDR_MONITOR_USERS";
        }
        if (this.DbTableRoles == null) {
            this.DbTableRoles = "PDR_MONITOR_ROLES";
        }
        if (this.DbTableUserGrants == null) {
            this.DbTableUserGrants = "PDR_MONITOR_USER_GRANTS";
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        this.setDefaultValues();
        return this;
    }
}

