/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Authentication;

import au.com.aemo.Common.Authentication.ActiveDirectory;
import au.com.aemo.Common.Authentication.AuthenticationConfig;
import au.com.aemo.Common.Authentication.IdentityPrincipal;
import au.com.aemo.Common.Authentication.IdentityProviderBase;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.naming.ldap.LdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityProviderAD
extends IdentityProviderBase {
    private static Logger logger = LoggerFactory.getLogger(IdentityProviderAD.class);

    @Override
    public String getId() {
        return "ACTIVE_DIRECTORY";
    }

    @Override
    public boolean managesPasswords() {
        return false;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void configure(AuthenticationConfig authenticationConfig) throws Exception {
        super.configure(authenticationConfig);
        if (Util.isBlank(this.authConfig.ActiveDirectoryDomainName)) {
            throw new Exception("Missing parameter for ActiveDirectoryDomainName");
        }
    }

    @Override
    public String resetPassword(String string, String string2) throws Exception {
        throw new UnsupportedOperationException("Reset password not supported for Active Directory");
    }

    @Override
    public IdentityPrincipal authenticateUser(String string, String string2) {
        IdentityPrincipal identityPrincipal = null;
        try {
            LdapContext ldapContext = ActiveDirectory.getConnection(string, string2, this.authConfig.ActiveDirectoryDomainName);
            ldapContext.close();
            IdentityPrincipal identityPrincipal2 = this.i.Users.get(string.toUpperCase().trim());
            if (identityPrincipal2 != null && Util.intToBoolean(identityPrincipal2.Is_Active)) {
                identityPrincipal = identityPrincipal2;
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error processing user login: " + exception.getMessage(), exception);
        }
        return identityPrincipal;
    }
}

