/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ConfigurationValueResolver;
import au.com.aemo.Common.Cryptography.Crypt;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDatabaseScriptRunnerNative {
    private static Logger logger = LoggerFactory.getLogger(AppDatabaseScriptRunnerNative.class);

    private static boolean runProcess(String string, List<String> list) throws Exception {
        Object object;
        Map<String, String> map;
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (logger.isDebugEnabled()) {
            Util_Logger.debug(logger, "Command: " + list.toString());
        }
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("cmd");
            arrayList.add("/c");
        } else {
            arrayList.add("/bin/bash");
            arrayList.add("-c");
        }
        arrayList.add(String.join((CharSequence)" ", list));
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.redirectErrorStream(true);
        if (!Util.isBlank(string)) {
            map = processBuilder.environment();
            object = (String)map.get("PATH");
            object = !Util.isBlank((String)object) ? string + (bl ? ";" : ":") + (String)object : string;
            map.put("PATH", (String)object);
        }
        map = processBuilder.start();
        object = new Scanner(((Process)((Object)map)).getInputStream());
        while (((Scanner)object).hasNextLine()) {
            String string2 = ((Scanner)object).nextLine();
            System.out.println(string2);
        }
        ((Process)((Object)map)).waitFor();
        bl2 = ((Process)((Object)map)).exitValue() == 0;
        return bl2;
    }

    public static void main(String[] stringArray) {
        Object object;
        Options options = new Options();
        options.addRequiredOption("u", "user", true, "The database user");
        options.addRequiredOption("p", "password", true, "The encrypted database password");
        options.addRequiredOption("d", "database", true, "The database to connect to");
        options.addRequiredOption("s", "script", true, "The SQL script to run");
        options.addOption("h", "host", true, "The database server host");
        options.addOption("o", "port", true, "The database server port");
        options.addRequiredOption("t", "type", true, "The database type (oracle,sqlserver,mysql,postgresql)");
        options.addOption("a", "path", true, "The path to the native command line client");
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            object = new HelpFormatter();
            object.printHelp("AppDatabaseScriptRunnerNative", options);
            System.exit(1);
        }
        String string = commandLine.getOptionValue("user");
        object = commandLine.getOptionValue("password");
        String string2 = commandLine.getOptionValue("database");
        String string3 = commandLine.getOptionValue("script");
        String string4 = commandLine.getOptionValue("host");
        String string5 = commandLine.getOptionValue("port");
        String string6 = commandLine.getOptionValue("type");
        Object object2 = commandLine.getOptionValue("path", "");
        ArrayList<String> arrayList = commandLine.getArgList();
        Util_Logger.info(logger, "Starting AppDatabaseScriptRunnerNative with script " + string3);
        Crypt crypt = Crypt.getInstance();
        ConfigurationValueResolver configurationValueResolver = new ConfigurationValueResolver();
        if (arrayList != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string7 : arrayList) {
                arrayList2.add(configurationValueResolver.resolveValue(string7, false));
            }
            arrayList = arrayList2;
        }
        try {
            object = crypt.decrypt((String)object);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error decrypting database password : " + exception.getMessage(), exception);
            System.exit(1);
        }
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (!Util.isBlank((String)object2)) {
            if (bl) {
                if (!((String)object2).endsWith("\\")) {
                    object2 = (String)object2 + "\\";
                }
            } else if (!((String)object2).endsWith("/")) {
                object2 = (String)object2 + "/";
            }
        }
        ArrayList arrayList3 = new ArrayList();
        switch (string6.trim().toLowerCase()) {
            case "oracle": {
                string5 = Util.isBlank(string5, "1521");
                if (Util.isBlank(string4)) {
                    arrayList3.add("echo exit | sqlplus -L " + string + "/" + (String)object + "@" + string2 + " @\"" + string3 + "\"");
                    break;
                }
                arrayList3.add("echo exit | sqlplus -L " + string + "/" + (String)object + "@" + string4 + ":" + string5 + "/" + string2 + " @\"" + string3 + "\"");
                break;
            }
            case "sqlserver": {
                string5 = Util.isBlank(string5, "1433");
                arrayList3.add("sqlcmd");
                arrayList3.add("-U");
                arrayList3.add(string);
                arrayList3.add("-P");
                arrayList3.add(object);
                arrayList3.add("-S");
                arrayList3.add(string4 + "," + string5);
                arrayList3.add("-d");
                arrayList3.add(string2);
                arrayList3.add("-b");
                arrayList3.add("-e");
                arrayList3.add("-i");
                arrayList3.add(string3);
                break;
            }
            case "mysql": {
                string5 = Util.isBlank(string5, "3306");
                arrayList3.add("mysql");
                arrayList3.add("-u");
                arrayList3.add(string);
                arrayList3.add("--password=" + (String)object);
                arrayList3.add("--host=" + string4);
                arrayList3.add("--port=" + string5);
                arrayList3.add("--database=" + string2);
                arrayList3.add("--silent");
                arrayList3.add("<");
                arrayList3.add(string3);
                break;
            }
            case "postgresql": {
                string5 = Util.isBlank(string5, "5432");
                arrayList3.add("psql");
                arrayList3.add("-f");
                arrayList3.add(string3);
                arrayList3.add("postgresql://" + string + ":" + (String)object + "@" + string4 + ":" + string5 + "/" + string2);
                break;
            }
            default: {
                Util_Logger.errorNoRaise(logger, "Unsupported database type [" + string6 + "]. Supported types are (oracle,sqlserver,mysql,postgresql)");
                System.exit(1);
            }
        }
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        boolean bl2 = false;
        try {
            bl2 = AppDatabaseScriptRunnerNative.runProcess((String)object2, arrayList3);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2) {
            Util_Logger.info(logger, "Successfully completed script " + string3);
            System.exit(0);
        } else {
            Util_Logger.errorNoRaise(logger, "Detected error running script " + string3);
            System.exit(1);
        }
    }
}

