/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DbColumnMapping;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbHandlerField;
import au.com.aemo.Common.Database.DbHandlerMetadata;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbTableMapper;
import au.com.aemo.Common.Database.DbTableMapperColumn;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerMetadataManager {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerMetadataManager.class);
    private ConcurrentMap<String, DbHandlerMetadata> itsObjects;
    private Date itsCacheFlushDate = new Date();
    private ConcurrentMap<String, DbTableMapper> itsMappers;

    private DbHandlerMetadataManager() {
        this.itsObjects = new ConcurrentHashMap<String, DbHandlerMetadata>();
        this.itsMappers = new ConcurrentHashMap<String, DbTableMapper>();
    }

    public static DbHandlerMetadataManager getInstance() {
        return SingletonHolder.instance;
    }

    public void clearCache() {
        this.itsObjects.clear();
        this.itsCacheFlushDate = new Date();
        Util_Logger.info(logger, "Flushed database structure cache");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Method is consumed by trusted code")
    public Date getCacheFlushDate() {
        return this.itsCacheFlushDate;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"}, justification="No material impact to functionality")
    public DbHandlerMetadata getMetadata(Connection connection, DbHandler dbHandler, String string, String string2) throws ApplicationException {
        DbHandlerMetadata dbHandlerMetadata = null;
        String string3 = string + "_" + string2;
        try {
            dbHandlerMetadata = (DbHandlerMetadata)this.itsObjects.get(string3);
            if (dbHandlerMetadata == null) {
                dbHandlerMetadata = new DbHandlerMetadata(string, string2);
                dbHandlerMetadata.getDbMetaData(connection, dbHandler);
                this.itsObjects.putIfAbsent(string3, dbHandlerMetadata);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error loading meta-data for key " + string3 + ": " + exception.getMessage(), exception);
        }
        return dbHandlerMetadata;
    }

    private List<Field> getAllModelFields(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        do {
            Collections.addAll(arrayList, clazz.getDeclaredFields());
        } while ((clazz = clazz.getSuperclass()) != null);
        return arrayList;
    }

    public DbTableMapper getMapper(Connection connection, Class clazz, String string, String string2) throws ApplicationException {
        DbHandler dbHandler;
        DbHandlerMetadata dbHandlerMetadata;
        String string3 = string + ":" + string2 + ":" + clazz.getName();
        DbTableMapper dbTableMapper = (DbTableMapper)this.itsMappers.get(string3);
        if (dbTableMapper == null && (dbHandlerMetadata = this.getMetadata(connection, dbHandler = DbManager.getDbHandler(), string, string2)) != null) {
            dbTableMapper = new DbTableMapper();
            dbTableMapper.TableName = string2;
            dbTableMapper.ClassName = clazz;
            List<Field> list = this.getAllModelFields(clazz);
            for (Map.Entry<String, DbHandlerField> entry : dbHandlerMetadata.getColumnList().entrySet()) {
                DbTableMapperColumn dbTableMapperColumn = new DbTableMapperColumn();
                dbTableMapperColumn.ColumnName = entry.getKey();
                String string4 = entry.getKey();
                dbTableMapperColumn.Definition = entry.getValue();
                String string5 = string4.replace("_", "");
                for (Field field : list) {
                    String string6 = field.getName();
                    DbColumnMapping dbColumnMapping = field.getAnnotation(DbColumnMapping.class);
                    if (dbColumnMapping != null) {
                        string6 = dbColumnMapping.value();
                    }
                    if (string6.equalsIgnoreCase(string4)) {
                        dbTableMapperColumn.objectProperty = field;
                        field.setAccessible(true);
                        break;
                    }
                    if (!string6.equalsIgnoreCase(string5)) continue;
                    dbTableMapperColumn.objectProperty = field;
                    field.setAccessible(true);
                    break;
                }
                if (dbTableMapperColumn.objectProperty == null) continue;
                dbTableMapper.Columns.put(dbTableMapperColumn.ColumnName, dbTableMapperColumn);
            }
            this.itsMappers.put(string3, dbTableMapper);
        }
        return dbTableMapper;
    }

    private static class SingletonHolder {
        private static DbHandlerMetadataManager instance = new DbHandlerMetadataManager();

        private SingletonHolder() {
        }
    }
}

