/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbHandlerField;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbPreparedStatementParam;
import au.com.aemo.Common.Database.DbSpaceStats;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerOracle
extends DbHandler {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerOracle.class);

    public DbHandlerOracle(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    @Override
    public void preConnect(Properties properties) {
        properties.put("v$session.program", this.getAppName() + " " + this.getAppVersion());
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="SQL statement uses only variables from application properties configuration file and is therefore not vulnerable to SQL injection")
    public void afterConnect(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            if (!Util.isBlank(this.getDbDateFormat())) {
                statement.execute("ALTER SESSION SET NLS_DATE_FORMAT='" + this.getDbDateFormat() + "'");
            }
            if (!Util.isBlank(this.getDbTimestampFormat())) {
                statement.execute("ALTER SESSION SET NLS_TIMESTAMP_FORMAT='" + this.getDbTimestampFormat() + "'");
            }
            if (this.getDefaultSchemaSQL() != null) {
                statement.execute(this.getDefaultSchemaSQL());
                Util_Logger.debug(logger, "Database session current schema set to " + this.getDefaultSchema());
            }
            statement.close();
        }
    }

    @Override
    public boolean checkSchemaExists(Connection connection, String string) throws ApplicationException {
        boolean bl = false;
        try {
            String string2 = "SELECT count(1) FROM ALL_USERS WHERE USERNAME = ?";
            try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                preparedStatement.setString(1, string.toUpperCase());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        bl = resultSet.getInt(1) > 0;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in checkSchemaExists: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    @Override
    public boolean checkTableExists(Connection connection, String string, String string2) throws ApplicationException {
        boolean bl = false;
        try (Statement statement = connection.createStatement();){
            Object object = "select count(1) from ";
            object = Util.isBlank(string) ? (String)object + "user_tables" : (String)object + "all_tables";
            object = (String)object + " where table_name = '" + string2.toUpperCase() + "'";
            if (!Util.isBlank(string)) {
                object = (String)object + " and owner = '" + string.toUpperCase() + "'";
            }
            try (ResultSet resultSet = statement.executeQuery((String)object);){
                while (resultSet.next()) {
                    bl = resultSet.getInt(1) > 0;
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in checkTableExists: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    @Override
    public boolean checkColumnExists(Connection connection, String string, String string2, String string3) throws ApplicationException {
        boolean bl = false;
        try (Statement statement = connection.createStatement();){
            Object object = "select count(1) from ";
            object = Util.isBlank(string) ? (String)object + "user_tab_columns" : (String)object + "all_tab_columns";
            object = (String)object + " where table_name = '" + string2.toUpperCase() + "'";
            object = (String)object + " and column_name = '" + string3.toUpperCase() + "'";
            if (!Util.isBlank(string)) {
                object = (String)object + " and owner = '" + string.toUpperCase() + "'";
            }
            try (ResultSet resultSet = statement.executeQuery((String)object);){
                while (resultSet.next()) {
                    bl = resultSet.getInt(1) > 0;
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in checkColumnExists: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    @Override
    public boolean getPreferExistsStatement() {
        return true;
    }

    @Override
    public Map<String, DbHandlerField> getColumnList(Connection connection, String string, String string2) throws ApplicationException {
        LinkedHashMap<String, DbHandlerField> linkedHashMap = new LinkedHashMap<String, DbHandlerField>();
        try (Statement statement = connection.createStatement();){
            Object object = "select column_name,data_type,nvl(data_precision,data_length) as data_length,data_scale from ";
            object = Util.isBlank(string) ? (String)object + "user_tab_columns" : (String)object + "all_tab_columns";
            object = (String)object + " where table_name = '" + string2.toUpperCase() + "'";
            if (!Util.isBlank(string)) {
                object = (String)object + " and owner = '" + string.toUpperCase() + "'";
            }
            object = (String)object + " order by column_id";
            try (ResultSet resultSet = statement.executeQuery((String)object);){
                while (resultSet.next()) {
                    DbHandlerField dbHandlerField = new DbHandlerField(resultSet.getString(1), resultSet.getString(2), this.maptoFieldTypeId(resultSet.getString(2)), resultSet.getInt(3), resultSet.getInt(4), linkedHashMap.size());
                    linkedHashMap.put(dbHandlerField.getFieldName().toUpperCase(), dbHandlerField);
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getColumnList: " + sQLException.getMessage(), sQLException);
        }
        return linkedHashMap;
    }

    @Override
    public List<String> getPkList(Connection connection, String string, String string2) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (Statement statement = connection.createStatement();){
            Object object = "select cc.column_name from ";
            object = Util.isBlank(string) ? (String)object + "user_cons_columns cc, user_constraints c " : (String)object + "all_cons_columns cc, all_constraints c ";
            object = (String)object + " where c.table_name = '" + string2.toUpperCase() + "'";
            if (!Util.isBlank(string)) {
                object = (String)object + " and c.owner = '" + string.toUpperCase() + "'";
            }
            object = (String)object + " and c.owner = cc.owner and c.constraint_name = cc.constraint_name  and c.constraint_type = 'P' order by cc.position";
            try (ResultSet resultSet = statement.executeQuery((String)object);){
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getPkList: " + sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    @Override
    public long getSequence(Connection connection, String string, String string2) throws ApplicationException {
        long l = -1L;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select " + this.getTableReference(string, string2) + ".nextval from dual");){
            while (resultSet.next()) {
                l = resultSet.getLong(1);
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getSequence: " + sQLException.getMessage(), sQLException);
        }
        return l;
    }

    @Override
    public String getCurrentDateTime() {
        return "sysdate";
    }

    @Override
    public String getCurrentUser() {
        return "USER";
    }

    @Override
    public String getCurrentSchema() {
        return "USER";
    }

    @Override
    public String getNoTable() {
        return "from dual";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        ArrayList<DbSpaceStats> arrayList = new ArrayList<DbSpaceStats>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            String string = "select\n     used.tablespace_name,\n     used.bytes as used_bytes,\n     reserv.maxbytes as max_bytes\nfrom\n    (select tablespace_name, count(1) datafiles, sum(greatest(maxbytes,bytes)) maxbytes, sum(bytes) bytes from dba_data_files group by tablespace_name) reserv,\n    (select tablespace_name, sum(bytes) bytes from dba_segments group by tablespace_name) used\n where used.tablespace_name = reserv.tablespace_name" + this.getTablespaceToReportSQL("and", "used.tablespace_name") + " order by 1";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                DbSpaceStats dbSpaceStats = new DbSpaceStats(resultSet.getString("tablespace_name"));
                dbSpaceStats.setUsedBytes(resultSet.getLong("used_bytes"));
                dbSpaceStats.setTotalBytes(resultSet.getLong("max_bytes"));
                arrayList.add(dbSpaceStats);
            }
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting database space statistics: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        return arrayList;
    }

    @Override
    public String getSqlDate(Date date) {
        return this.getSqlDate(Util.dateToStr(date, this.getJavaDateFormat()));
    }

    @Override
    public String getSqlDate(String string) {
        return "to_date('" + string + "','" + this.getDbDateFormat() + "')";
    }

    @Override
    public String concatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    @Override
    public String getDateFieldFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return this.getJavaDateFormat();
        }
        if (dbHandlerField.getFieldType().startsWith("TIMESTAMP")) {
            return this.getJavaTimestampFormat();
        }
        return null;
    }

    @Override
    public DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField == null) {
            return new DbPreparedStatementParam("?", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("NUMBER")) {
            return new DbPreparedStatementParam("to_number(?)", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return new DbPreparedStatementParam("to_date(?,'" + this.getDbDateFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().startsWith("TIMESTAMP")) {
            return new DbPreparedStatementParam("to_timestamp(?,'" + this.getDbTimestampFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("CHAR")) {
            return new DbPreparedStatementParam(this.rightPad("?", dbHandlerField.getDataLength()), 12);
        }
        return new DbPreparedStatementParam("?", 12);
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Return value not required for database connectivity check")
    public boolean isValid(Connection connection) {
        boolean bl = false;
        if (connection != null) {
            try {
                try (Statement statement = connection.createStatement();){
                    statement.executeQuery("select 1 from dual");
                }
                bl = true;
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error on SQL connection: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    @Override
    public String ifNull(String string, String string2) {
        return "NVL(" + string + "," + string2 + ")";
    }

    private String rightPad(String string, int n) {
        return "RPAD(" + string + "," + n + ")";
    }

    @Override
    public String getSqlRowLimited(String string, String string2, int n) {
        return "SELECT * from (SELECT " + string + " ORDER BY " + string2 + " ) where rownum <= " + n;
    }

    @Override
    public String getBitOperator(String string, String string2) {
        return "bitand(" + string + "," + string2 + ")";
    }

    @Override
    public String getSqlDateRoundUp(String string, int n) {
        int n2 = 1440 / n;
        String string2 = "cast(" + string + " as DATE)";
        return "CEIL((" + string2 + " - trunc(" + string2 + ")) * " + n2 + " )/" + n2 + " + trunc(" + string2 + ")";
    }

    @Override
    public String getSqlDateDiffInSecs(String string, String string2) {
        return "((extract(day from (to_timestamp(" + string2 + ")-to_timestamp(" + string + "))))*24*60*60+(extract(hour from (to_timestamp(" + string2 + ")-to_timestamp(" + string + "))))*60*60+(extract(minute from (to_timestamp(" + string2 + ")-to_timestamp(" + string + "))))*60+extract(second from (to_timestamp(" + string2 + ")-to_timestamp(" + string + "))))";
    }

    @Override
    public String getSqlDateAdd(String string, String string2, int n) throws Exception {
        switch (n) {
            case 13: {
                return "(" + string + " + (" + string2 + "/86400))";
            }
            case 12: {
                return "(" + string + " + (" + string2 + "/1440))";
            }
            case 11: {
                return "(" + string + " + (" + string2 + "/24))";
            }
            case 5: {
                return "(" + string + " + (" + string2 + "))";
            }
        }
        throw new Exception("Unsupported operation getSqlDateAdd for Calendar field ID " + n);
    }

    @Override
    public String getScriptDelimiter() {
        return "/";
    }

    @Override
    public String getCodeBlockDeclare() {
        return "declare";
    }

    @Override
    public String getCodeBlockBegin() {
        return "begin";
    }

    @Override
    public String getCodeBlockEnd() {
        return "end;";
    }

    @Override
    public String getDefaultSchemaSQL() {
        String string = null;
        if (!Util.isBlank(this.getDefaultSchema())) {
            string = "ALTER SESSION SET CURRENT_SCHEMA=" + this.getDefaultSchema();
        }
        return string;
    }

    @Override
    public boolean isPrimaryKeyViolation(SQLException sQLException) {
        return sQLException.getErrorCode() == Integer.parseInt(this.getPrimaryKeySQLErrorCode("1"));
    }
}

