/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionAPI;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebHttpResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionEHub
extends fsConnectionAPI {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionEHub.class);

    public fsConnectionEHub(String string, String string2, Proxy proxy, int n, int n2, boolean bl) {
        super(string, string2, proxy, n, n2, bl);
    }

    @Override
    public boolean supportsFileTimestamps() {
        return true;
    }

    private fsFileInfo eventToFile(fsEventData fsEventData2, String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        fsFileInfo fsFileInfo2 = new fsFileInfo();
        fsFileInfo2.setDirectory(string);
        fsFileInfo2.setEventData(fsEventData2);
        if (fsConnectionFileFilterInt2 != null) {
            fsFileInfo2.addAPIHeaderValues(fsConnectionFileFilterInt2.getAPIHeaderValues());
        }
        fsFileInfo2.setUniqueId(fsEventData2.getEventId());
        String string3 = FileNameTokenResolver.process(string2, fsFileInfo2);
        fsFileInfo2.setFilename(string3);
        return fsFileInfo2;
    }

    @Override
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        HashMap<String, fsFileInfo> hashMap;
        block20: {
            hashMap = new HashMap<String, fsFileInfo>();
            try {
                Object object2;
                String string3 = null;
                if (fsConnectionFileFilterInt2 != null) {
                    string3 = fsConnectionFileFilterInt2.getOutputFilenameMask();
                }
                if (Util.isBlank(string3)) {
                    throw new Exception("Missing specification for destination output file mask");
                }
                if (!Util.isBlank(string2)) {
                    List<fsEventData> list = FilesystemManager.getInstance().getNewFileEvents(string2);
                    Util_Logger.debug(logger, "Detected " + list.size() + " events");
                    for (fsEventData fsEventData2 : list) {
                        if (fsEventData2.isCompleted()) continue;
                        fsFileInfo fsFileInfo2 = this.eventToFile(fsEventData2, string, fsConnectionFileFilterInt2, string3);
                        hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
                    }
                    break block20;
                }
                WebClient webClient = this.getWebClient();
                String string4 = this.getURL(string) + "/retrieveMessageMetadata";
                Util_Logger.debug(logger, "Getting from URL: " + string4);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                if (fsConnectionFileFilterInt2.getDirListAPIHeaderValues() != null) {
                    object2 = Util.getList(fsConnectionFileFilterInt2.getDirListAPIHeaderValues(), ',');
                    Iterator object4 = object2.iterator();
                    while (object4.hasNext()) {
                        String[] stringArray;
                        String string5 = (String)object4.next();
                        if (Util.isBlank(string5) || (stringArray = Util.getColumns(string5, ':')) == null) continue;
                        if (stringArray.length == 2) {
                            hashMap2.put(stringArray[0], stringArray[1]);
                            continue;
                        }
                        throw new Exception("Invalid API header value [" + (String)string5 + "]");
                    }
                }
                for (Map.Entry entry : hashMap2.entrySet()) {
                    Util_Logger.debug(logger, "HTTP header [" + String.valueOf(entry.getKey()) + "] = [" + String.valueOf(entry.getValue()) + "]");
                }
                object2 = webClient.doGet(string4, hashMap2);
                if (((WebHttpResponse)object2).ReturnCode == 200) {
                    QueueDetails queueDetails = JsonUtilities.fromJson(((WebHttpResponse)object2).Body, QueueDetails.class);
                    if (queueDetails != null) {
                        if (queueDetails.queueReport != null && queueDetails.queueReport.messageDetails != null) {
                            for (MessageDetail messageDetail : queueDetails.queueReport.messageDetails) {
                                if (!Util.isBlank(messageDetail.messageContextId)) {
                                    fsFileInfo fsFileInfo2 = new fsFileInfo();
                                    if (messageDetail.messageMetaData != null) {
                                        for (MessageMetaData messageMetaData : messageDetail.messageMetaData) {
                                            fsFileInfo2.addEventParameter(messageMetaData.name, messageMetaData.value);
                                        }
                                    }
                                    for (Map.Entry entry : hashMap2.entrySet()) {
                                        fsFileInfo2.addEventParameter((String)entry.getKey(), (String)entry.getValue());
                                    }
                                    List<Field> list = Arrays.asList(MessageDetail.class.getDeclaredFields());
                                    fsFileInfo2.addEventParameter("businessFunction", queueDetails.queueReport.businessFunction);
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        Object object;
                                        Field field = (Field)iterator.next();
                                        if (Collection.class.isAssignableFrom(field.getType()) || (object = field.get(messageDetail)) == null) continue;
                                        fsFileInfo2.addEventParameter(field.getName(), field.get(messageDetail).toString());
                                    }
                                    fsFileInfo2.setUniqueId(messageDetail.messageContextId);
                                    String string6 = FileNameTokenResolver.process(string3, fsFileInfo2);
                                    fsFileInfo2.setFilename(string6);
                                    fsFileInfo2.setDirectory(string);
                                    fsFileInfo2.setModifiedDate(new Date(), true);
                                    fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
                                    hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
                                    continue;
                                }
                                Util_Logger.warning(logger, "Detected invalid message in queue report with missing messageContextId, skipping entry");
                            }
                        }
                    } else {
                        throw new Exception("Unable to parse JSON reponse");
                    }
                    Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
                    break block20;
                }
                throw new Exception("Unable to extract pending messages, return code = " + ((WebHttpResponse)object2).ReturnCode + ", message: " + Util.noNull(((WebHttpResponse)object2).Body));
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error listing directory " + string + " from AEMO EHub: " + exception.getMessage(), exception);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        fsFileInfo fsFileInfo3 = null;
        File file = null;
        try {
            WebClient webClient = this.getWebClient();
            String string2 = this.getURL(fsFileInfo2.getDirectory()) + "/retrieveMessage";
            Util_Logger.debug(logger, "Getting from URL: " + string2);
            if (fsFileInfo2.getAPIHeaderValues() != null) {
                for (Map.Entry object : fsFileInfo2.getAPIHeaderValues().entrySet()) {
                    Util_Logger.debug(logger, "HTTP header [" + String.valueOf(object.getKey()) + "] = [" + String.valueOf(object.getValue()) + "]");
                }
            }
            WebHttpResponse webHttpResponse = webClient.doGet(string2, fsFileInfo2.getAPIHeaderValues());
            if (webHttpResponse.ReturnCode == 200) {
                void var8_15;
                Object var8_11 = null;
                if (webHttpResponse.ContentType.equalsIgnoreCase("application/xml")) {
                    String string3 = fsFileInfo2.getFilename() + ".xml";
                } else if (webHttpResponse.ContentType.equalsIgnoreCase("application/json")) {
                    String string4 = fsFileInfo2.getFilename() + ".json";
                } else if (webHttpResponse.ContentType.equalsIgnoreCase("application/csv")) {
                    String string5 = fsFileInfo2.getFilename() + ".csv";
                } else {
                    throw new Exception("Unsupported content type [" + webHttpResponse.ContentType + "]");
                }
                file = new File(string + "/" + (String)var8_15);
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.write(webHttpResponse.Body.getBytes());
                    fileOutputStream.flush();
                }
                if (fsFileInfo2.getModifiedDate() != null && !file.setLastModified(fsFileInfo2.getModifiedDate().getTime())) {
                    Util_Logger.warning(logger, "Unable to set modified time on file [" + file.getName() + "]");
                }
            } else {
                throw new Exception("response code is " + webHttpResponse.ReturnCode + ", message [" + Util.noNull(webHttpResponse.Body) + "]");
            }
            fsFileInfo3 = new fsFileInfo(file);
        }
        catch (Exception exception) {
            try {
                if (file != null) {
                    FileUtilities.deleteFile(file);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error getting file " + fsFileInfo2.getFilename() + " from EHub: " + exception.getMessage(), exception);
        }
        return fsFileInfo3;
    }

    @Override
    public void deleteFile(fsFileInfo fsFileInfo2) throws Exception {
        try {
            WebClient webClient = this.getWebClient();
            String string = FileNameTokenResolver.process("{docId}", fsFileInfo2);
            String string2 = this.getURL(fsFileInfo2.getDirectory()) + "/acknowledgeMessage/" + string;
            WebHttpResponse webHttpResponse = webClient.doGet(string2, fsFileInfo2.getAPIHeaderValues());
            if (webHttpResponse.ReturnCode != 200) {
                throw new Exception("response code is " + webHttpResponse.ReturnCode + ", message [" + Util.noNull(webHttpResponse.Body) + "]");
            }
            Util_Logger.info(logger, "Successfully acknowledged message [" + string + "]");
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error acknowledging file " + fsFileInfo2.getFilename() + " from EHub: " + exception.getMessage(), exception);
        }
    }

    class QueueDetails {
        public QueueReport queueReport;

        QueueDetails() {
        }
    }

    class QueueReport {
        public String transactionId;
        public String businessFunction;
        public Date date;
        public int resultCount;
        public List<MessageDetail> messageDetails = new ArrayList<MessageDetail>();

        QueueReport() {
        }
    }

    class MessageDetail {
        public String docId;
        public String eventId;
        public String messageContextId;
        public String messageType;
        public String messageConfidentiality;
        public Date messageDate2;
        public List<MessageMetaData> messageMetaData = new ArrayList<MessageMetaData>();

        MessageDetail() {
        }
    }

    class MessageMetaData {
        public String name;
        public String value;

        MessageMetaData() {
        }
    }
}

