/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionAPI;
import au.com.aemo.Common.FileSystem.fsConnectionEHub;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryBase;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebClientAuthInt;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionFactoryEHub
extends fsConnectionFactoryBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionFactoryEHub.class);

    private fsConnectionFactoryEHub() {
        super("EHUB");
    }

    public static fsConnectionFactoryEHub getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public fsConnectionInt getConnection(String string) {
        Object object;
        Proxy proxy = null;
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        String string2 = filesystemManager.getConfig(string + "_url", "");
        String string3 = filesystemManager.getConfig(string + "_proxy_host", "");
        String string4 = filesystemManager.getConfig(string + "_proxy_port", "");
        int n = Integer.parseInt(filesystemManager.getConfig(string + "_timeout_connection", "10"));
        int n2 = Integer.parseInt(filesystemManager.getConfig(string + "_timeout_transfer", "120"));
        boolean bl = filesystemManager.getConfig(string + "_default_ssl_context", "false").equalsIgnoreCase("true");
        if (!Util.isBlank(string3) && !Util.isBlank(string4)) {
            object = new InetSocketAddress(string3, Integer.parseInt(string4));
            proxy = new Proxy(Proxy.Type.HTTP, (SocketAddress)object);
        }
        object = new fsConnectionEHub(string, string2, proxy, n, n2, bl);
        WebClientAuthInt webClientAuthInt = filesystemManager.getWebAuthProvider(string);
        ((fsConnectionAPI)object).setAuthProvider(webClientAuthInt);
        return object;
    }

    private static class SingletonHolder {
        private static fsConnectionFactoryEHub instance = new fsConnectionFactoryEHub();

        private SingletonHolder() {
        }
    }
}

