/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FTP.FtpConnectionInt;
import au.com.aemo.Common.FileSystem.fsConnectionBase;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsConnectionLocal;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionFtp
extends fsConnectionBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionFtp.class);
    private FtpConnectionInt itsConnection;
    private String itsDataSourceId;
    private fsConnectionLocal itsLocal;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsConnectionFtp(FtpConnectionInt ftpConnectionInt, String string) {
        super(string);
        this.itsConnection = ftpConnectionInt;
        this.itsDataSourceId = string;
        this.itsLocal = new fsConnectionLocal(string, false, null);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    protected FtpConnectionInt getConnection() {
        return this.itsConnection;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return true;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        fsFileInfo fsFileInfo2 = new fsFileInfo();
        int n = string.lastIndexOf("/");
        if (n < 0) {
            throw new Exception("Missing folder specification (/) in filename [" + string + "]");
        }
        fsFileInfo2.setDirectory(string.substring(0, n));
        fsFileInfo2.setFilename(string.substring(n + 1));
        return fsFileInfo2;
    }

    @Override
    public void makeDir(String string) throws Exception {
        this.itsConnection.mkdir(string);
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsConnection.chdir(string);
    }

    @Override
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        fsFileInfo[] fsFileInfoArray = this.itsConnection.dir(string, fsConnectionFileFilterInt2);
        if (fsFileInfoArray != null) {
            for (fsFileInfo fsFileInfo2 : fsFileInfoArray) {
                hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
            }
        }
        return hashMap;
    }

    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        this.itsConnection.chdir(fsFileInfo2.getDirectory());
        this.itsConnection.get(string, fsFileInfo2.getFilename());
        File file = new File(this.itsLocal.fixDir(string) + File.separatorChar + fsFileInfo2.getFilename());
        if (fsFileInfo2.getModifiedDate() != null && !file.setLastModified(fsFileInfo2.getModifiedDate().getTime())) {
            Util_Logger.warning(logger, "Unable to set modified time on file [" + file.getName() + "]");
        }
        fsFileInfo fsFileInfo3 = new fsFileInfo(fsFileInfo2);
        fsFileInfo3.setDirectory(string);
        return fsFileInfo3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="File will always have a parent directory and a filename so will never return null from either of these methods")
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        Path path = null;
        try {
            path = Files.createTempFile("ftp_upload_" + this.itsDataSourceId, ".tmp", new FileAttribute[0]);
            Files.write(path, byArray, new OpenOption[0]);
            this.itsConnection.chdir(string);
            this.itsConnection.put(path.toString(), string2);
        }
        finally {
            if (path != null) {
                this.itsLocal.deleteFile(path.getParent().toString(), path.getFileName().toString());
            }
        }
    }

    @Override
    public fsProcessStatus putFile(fsFileInfo fsFileInfo2, String string, boolean bl, String string2) throws Exception {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        this.itsConnection.chdir(string);
        this.itsConnection.put(fsFileInfo2.getDirectory() + "/" + fsFileInfo2.getFilename(), fsFileInfo2.getFilename());
        if (bl) {
            this.itsLocal.deleteFile(fsFileInfo2);
        }
        fsProcessStatus2.setProcessSuccess();
        return fsProcessStatus2;
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        this.itsConnection.chdir(string);
        this.itsConnection.delete(string2);
    }

    @Override
    public void setBandwidthThrottle(int n) {
        this.itsConnection.setBandwidthThrottle(n);
    }

    @Override
    public void setTransferBufferSize(int n) {
        this.itsConnection.setTransferBufferSize(n);
    }

    @Override
    public void disconnect() throws Exception {
        this.itsConnection.disconnect();
    }

    @Override
    public boolean exists(String string, String string2) throws Exception {
        return this.itsConnection.exists(string, string2);
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return this.itsConnection.exists(fsFileInfo2);
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        this.itsConnection.chdir(string);
        this.itsConnection.rename(string + "/" + string2, string3 + "/" + string4);
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        return new fsFileLockNone();
    }
}

