/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsEventListenerInt;
import au.com.aemo.Common.FileSystem.fsEventNotificationInt;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class fsEventNotificationBase
implements fsEventNotificationInt {
    private static Logger logger = LoggerFactory.getLogger(fsEventNotificationBase.class);
    private static final JexlEngine JEXL_ENGINE = new JexlBuilder().cache(512).strict(false).silent(false).create();
    private String itsEventSourceId;
    private List<fsEventListenerInt> itsListeners;
    private Map<String, JexlExpression> itsListenerBindings;
    private volatile Map<String, List<fsEventData>> itsEventNewFiles = new HashMap<String, List<fsEventData>>();

    public fsEventNotificationBase(String string) {
        this.itsEventSourceId = string;
        this.itsListeners = new ArrayList<fsEventListenerInt>();
        this.itsListenerBindings = new HashMap<String, JexlExpression>();
    }

    @Override
    public String getEventSourceId() {
        return this.itsEventSourceId;
    }

    @Override
    public synchronized void registerListener(fsEventListenerInt fsEventListenerInt2) {
        Util_Logger.info(logger, "Registering listener [" + fsEventListenerInt2.getEventConsumerId() + "] to event notification source [" + this.itsEventSourceId + "]");
        this.itsListeners.add(fsEventListenerInt2);
        if (!Util.isBlank(fsEventListenerInt2.getEventDataSourceBinding())) {
            Util_Logger.debug(logger, "Event binding for [" + fsEventListenerInt2.getEventConsumerId() + "] is [" + fsEventListenerInt2.getEventDataSourceBinding() + "]");
            JexlExpression jexlExpression = JEXL_ENGINE.createExpression(fsEventListenerInt2.getEventDataSourceBinding());
            this.itsListenerBindings.put(fsEventListenerInt2.getDataSourceId(), jexlExpression);
        }
    }

    @Override
    public int getListenerCount() {
        return this.itsListeners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addNewFileEvent(fsEventData fsEventData2) {
        ArrayList<fsEventListenerInt> arrayList = new ArrayList<fsEventListenerInt>();
        Map<String, List<fsEventData>> map = this.itsEventNewFiles;
        synchronized (map) {
            for (fsEventListenerInt fsEventListenerInt2 : this.itsListeners) {
                Object object;
                boolean bl = true;
                JexlExpression jexlExpression = this.itsListenerBindings.get(fsEventListenerInt2.getDataSourceId());
                if (jexlExpression != null) {
                    object = new MapContext();
                    if (fsEventData2.getEventParameters() != null) {
                        for (Map.Entry<String, String> entry : fsEventData2.getEventParameters().entrySet()) {
                            object.set(entry.getKey(), (Object)entry.getValue());
                            Util_Logger.debug(logger, "Adding JEXL context variable [" + entry.getKey() + "] with value [" + entry.getValue() + "]");
                        }
                    }
                    bl = (Boolean)jexlExpression.evaluate((JexlContext)object);
                }
                Util_Logger.debug(logger, "Event [" + fsEventData2.getEventId() + "] " + (bl ? "accepted" : "rejected") + " in listener [" + fsEventListenerInt2.getDataSourceId() + "]");
                if (!bl) continue;
                object = this.itsEventNewFiles.get(fsEventListenerInt2.getEventConsumerId());
                if (object == null) {
                    object = new ArrayList();
                    this.itsEventNewFiles.put(fsEventListenerInt2.getEventConsumerId(), (List<fsEventData>)object);
                }
                object.add(fsEventData2);
                Util_Logger.debug(logger, "Added event [" + fsEventData2.getEventId() + "] to consumer [" + fsEventListenerInt2.getEventConsumerId() + "], total events in queue is " + object.size());
                ArrayList arrayList2 = new ArrayList();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    fsEventData fsEventData3 = (fsEventData)iterator.next();
                    if (!fsEventData3.isCompleted()) continue;
                    arrayList2.add(fsEventData3);
                }
                object.removeAll(arrayList2);
                arrayList.add(fsEventListenerInt2);
            }
        }
        if (arrayList.size() > 0) {
            for (fsEventListenerInt fsEventListenerInt3 : arrayList) {
                Util_Logger.debug(logger, "Notifying consumer [" + fsEventListenerInt3.getEventConsumerId() + "] of new event [" + fsEventData2.getEventId() + "]");
                fsEventListenerInt3.notifyNewFileEvent();
            }
        } else {
            Util_Logger.warning(logger, "No consumers registered for notifications from event source [" + fsEventData2.getEventSourceId() + "] for Event ID [" + fsEventData2.getEventId() + "]");
        }
    }

    @Override
    public List<fsEventData> getNewFileEvents(String string) {
        List<fsEventData> list;
        ArrayList<fsEventData> arrayList = new ArrayList<fsEventData>();
        if (!Util.isBlank(string) && (list = this.itsEventNewFiles.get(string)) != null) {
            for (fsEventData fsEventData2 : list) {
                if (fsEventData2.isCompleted()) continue;
                arrayList.add(fsEventData2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void processedNewFileEvent(String string, List<fsEventData> list) {
        if (list != null && list.size() > 0) {
            Map<String, List<fsEventData>> map = this.itsEventNewFiles;
            synchronized (map) {
                List<fsEventData> list2 = this.itsEventNewFiles.get(string);
                if (list2 != null) {
                    list2.removeAll(list);
                }
            }
        }
    }
}

