/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsEventNotificationBase;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebClientAuthInt;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.net.http.WebSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsEventNotificationWebSocket
extends fsEventNotificationBase
implements WebSocket.Listener {
    private static Logger logger = LoggerFactory.getLogger(fsEventNotificationWebSocket.class);
    private String itsWebSocketURL;
    private Map<String, String> itsHeaderValues;
    private WebClient wsClient;
    private WebSocket wsConnection;
    private int waitBeforeReconnectSecs;
    private boolean isActive;
    private List<Integer> restartOnCloseCodes;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsEventNotificationWebSocket(String string) throws Exception {
        super(string);
        List<String> list;
        Object object;
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        this.itsWebSocketURL = filesystemManager.getConfig(string + "_notification_url", null);
        String string2 = filesystemManager.getConfig(string + "_proxy_host", null);
        Integer n = null;
        if (!Util.isBlank(string2)) {
            n = Integer.valueOf(filesystemManager.getConfig(string + "_proxy_port", null));
        }
        this.waitBeforeReconnectSecs = Integer.valueOf(filesystemManager.getConfig(string + "_fail_wait_seconds", "30"));
        this.restartOnCloseCodes = new ArrayList<Integer>();
        String string3 = filesystemManager.getConfig(string + "_restart_close_codes", null);
        if (!Util.isBlank(string3)) {
            object = Util.getList(string3, ',');
            list = object.iterator();
            while (list.hasNext()) {
                String string4 = list.next();
                if (!Util.isInteger(string4)) continue;
                this.restartOnCloseCodes.add(Integer.valueOf(string4));
            }
        }
        if (!Util.isBlank((String)(object = filesystemManager.getConfig(string + "_header_values", null)))) {
            this.itsHeaderValues = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            list = Util.getList((String)object, ',');
            for (String string5 : list) {
                if (Util.isBlank(string5)) continue;
                int n2 = string5.indexOf(":");
                if (n2 > 0) {
                    String string6 = string5.substring(0, n2);
                    String string7 = string5.substring(n2 + 1);
                    Util_Logger.debug(logger, "Detected WebSocket API header value [" + string6 + "] to [" + string7 + "]");
                    this.itsHeaderValues.put(string6, string7);
                    continue;
                }
                throw new Exception("Detected invalid API header value specification [" + string5 + "] for WebSocket event source [" + string + "]");
            }
        }
        list = filesystemManager.getWebAuthProvider(string);
        boolean bl = filesystemManager.getConfig(string + "_default_ssl_context", "true").equalsIgnoreCase("true");
        this.wsClient = new WebClient().setUseDefaultSSLContext(bl).setAuthProvider((WebClientAuthInt)((Object)list));
        if (string2 != null) {
            this.wsClient = this.wsClient.setProxy(string2, n);
        }
        this.isActive = true;
    }

    private void restartService() {
        if (this.isActive) {
            new Thread(() -> {
                try {
                    Util_Logger.debug(logger, "Waiting " + this.waitBeforeReconnectSecs + " seconds before attempting restart of WebSocket on event source [" + this.getEventSourceId() + "]");
                    Thread.sleep(this.waitBeforeReconnectSecs * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.start();
            }).start();
        }
    }

    @Override
    public void start() {
        try {
            Util_Logger.info(logger, "Starting WebSocket event notification on URL [" + this.itsWebSocketURL + "]");
            this.wsConnection = this.wsClient.connectToWebSocket(this.itsWebSocketURL, this.itsHeaderValues, this);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Unable to start WebSocket services to [" + this.itsWebSocketURL + "]: " + exception.getMessage(), exception);
            this.restartService();
        }
    }

    @Override
    public void stop() {
        this.isActive = false;
        if (this.wsConnection != null) {
            try {
                Util_Logger.info(logger, "Sending close signal to webSocket on event source [" + this.getEventSourceId() + "]");
                this.wsConnection.sendClose(1000, "Application shutdown");
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error stopping WebSocket for data source [" + this.getEventSourceId() + "]: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        Util_Logger.info(logger, "WebSocket connected using subprotocol " + webSocket.getSubprotocol());
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence charSequence, boolean bl) {
        if (charSequence != null) {
            Util_Logger.debug(logger, "WebSocket received message " + String.valueOf(charSequence));
            try {
                EventMessage eventMessage = JsonUtilities.fromJson(charSequence.toString(), EventMessage.class);
                MessageDetails messageDetails = eventMessage.messageDetails;
                if (messageDetails != null) {
                    fsEventData fsEventData2 = new fsEventData();
                    fsEventData2.setEventId(messageDetails.eventId);
                    fsEventData2.setEventDate(messageDetails.eventDate);
                    fsEventData2.setEventSourceId(this.getEventSourceId());
                    fsEventData2.setNotificationId(messageDetails.messageContextId);
                    List<Field> list = Arrays.asList(MessageDetails.class.getDeclaredFields());
                    for (Field object : list) {
                        Object object2 = object.get(messageDetails);
                        if (object2 == null) continue;
                        fsEventData2.addEventParameter(object.getName(), object.get(messageDetails).toString());
                    }
                    if (this.itsHeaderValues != null) {
                        for (Map.Entry entry : this.itsHeaderValues.entrySet()) {
                            fsEventData2.addEventParameter((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    this.addNewFileEvent(fsEventData2);
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error processing WebSocket message: " + exception.getMessage(), exception);
            }
        }
        return WebSocket.Listener.super.onText(webSocket, charSequence, bl);
    }

    @Override
    public void onError(WebSocket webSocket, Throwable throwable) {
        Util_Logger.errorNoRaise(logger, "Detected error on WebSocket: " + throwable.getMessage(), new Exception(throwable));
        this.restartService();
        WebSocket.Listener.super.onError(webSocket, throwable);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int n, String string) {
        Util_Logger.info(logger, "WebSocket closed with status [" + n + "] and reason [" + string + "]");
        boolean bl = false;
        if (this.restartOnCloseCodes != null) {
            for (int n2 : this.restartOnCloseCodes) {
                if (n != n2) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.restartService();
        }
        return WebSocket.Listener.super.onClose(webSocket, n, string);
    }

    class EventMessage {
        public MessageDetails messageDetails;

        EventMessage() {
        }
    }

    class MessageDetails {
        public String businessFunction;
        public String docId;
        public String eventId;
        public Date eventDate;
        public String market;
        public String messageContextId;
        public String messageType;
        public String priority;
        public String fromParticipant;

        MessageDetails() {
        }
    }
}

