/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Files;

import au.com.aemo.Common.Java.Util;

public class FileMaskSpecification {
    public static final String FILE_MASK_MODE_EXCLUSIVE = "EXCLUSIVE";
    public static final String FILE_MASK_MODE_AND = "AND";
    private String[] itsIncludeFileMask;
    private String[] itsExcludeFileMask;
    private String itsFileMaskMode = "EXCLUSIVE";

    public void setIncludeFileMask(String string) {
        if (!Util.isBlank(string)) {
            this.itsIncludeFileMask = string.split(",");
        }
    }

    public void setExcludeFileMask(String string) {
        if (!Util.isBlank(string)) {
            this.itsExcludeFileMask = string.split(",");
        }
    }

    public void setFileMaskMode(String string) throws Exception {
        if (Util.isBlank(string)) {
            throw new Exception("File mask mode is not defined");
        }
        if (string.equalsIgnoreCase(FILE_MASK_MODE_EXCLUSIVE)) {
            this.itsFileMaskMode = string;
        } else if (string.equalsIgnoreCase(FILE_MASK_MODE_AND)) {
            this.itsFileMaskMode = string;
        } else {
            throw new Exception("Unsupported file mask mode [" + string + "]");
        }
        this.itsFileMaskMode = string;
    }

    public String getDirectoryListFileMask() {
        String string = null;
        boolean bl = false;
        bl = this.itsExcludeFileMask != null ? this.itsExcludeFileMask.length == 0 : true;
        boolean bl2 = false;
        if (this.itsIncludeFileMask != null) {
            boolean bl3 = bl2 = this.itsIncludeFileMask.length == 1;
        }
        if (bl && bl2) {
            string = this.itsIncludeFileMask[0];
        }
        return string;
    }

    public String toString() {
        return this.getMaskDescriptionForLog();
    }

    private String getMaskDescription(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public String getMaskDescriptionForLog() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.itsIncludeFileMask == null && this.itsExcludeFileMask == null) {
            stringBuilder.append("Including *");
        } else if (this.itsIncludeFileMask != null && this.itsExcludeFileMask != null) {
            stringBuilder.append(this.getMaskDescription("Including", this.itsIncludeFileMask));
            stringBuilder.append("; ");
            stringBuilder.append(this.getMaskDescription("Excluding", this.itsExcludeFileMask));
            stringBuilder.append("; ");
            stringBuilder.append("mask mode = ");
            stringBuilder.append(this.itsFileMaskMode);
        } else if (this.itsIncludeFileMask != null) {
            stringBuilder.append(this.getMaskDescription("Including", this.itsIncludeFileMask));
        } else if (this.itsExcludeFileMask != null) {
            stringBuilder.append(this.getMaskDescription("Excluding", this.itsExcludeFileMask));
        }
        return stringBuilder.toString();
    }

    public boolean checkFileMask(String string) {
        boolean bl = false;
        if (string != null) {
            int n;
            String string2 = string.toLowerCase();
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.itsIncludeFileMask != null) {
                for (n = 0; n < this.itsIncludeFileMask.length; ++n) {
                    if (Util.isBlank(this.itsIncludeFileMask[n])) {
                        bl2 = true;
                        bl3 = true;
                        continue;
                    }
                    if (!Util.wildCardMatch(this.itsIncludeFileMask[n], string2)) continue;
                    bl2 = true;
                    bl3 = true;
                }
            } else {
                bl2 = true;
            }
            n = 1;
            if (this.itsExcludeFileMask != null) {
                for (int i = 0; i < this.itsExcludeFileMask.length; ++i) {
                    if (Util.isBlank(this.itsExcludeFileMask[i]) || !Util.wildCardMatch(this.itsExcludeFileMask[i], string2)) continue;
                    n = 0;
                }
            }
            if (this.itsFileMaskMode.equalsIgnoreCase(FILE_MASK_MODE_EXCLUSIVE)) {
                bl = bl2;
                if (!bl3) {
                    bl = bl2 && n != 0;
                }
            } else {
                bl = bl2 && n != 0;
            }
        }
        return bl;
    }
}

