/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.JSON;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.JSON.Transform;
import au.com.aemo.Common.JSON.Transforms;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.XML.XmlUtilities;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTransformManager {
    private static Logger logger = LoggerFactory.getLogger(JsonTransformManager.class);
    private Transforms itsTransforms;

    private JsonTransformManager() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new GsonJsonProvider();
            private final MappingProvider mappingProvider = new GsonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    public static JsonTransformManager getInstance() {
        return SingletonHolder.instance;
    }

    public String getConfigFile() {
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        return filesystemManager.getConfig("json_transform_config", "");
    }

    public void loadTransformConfig() throws Exception {
        this.loadTransformConfig(this.getConfigFile());
    }

    public void loadTransformConfig(String string) throws Exception {
        if (!Util.isBlank(string)) {
            XStream xStream = XmlUtilities.getConverter();
            xStream.processAnnotations(Transform.class);
            xStream.processAnnotations(Transforms.class);
            File file = new File(string);
            this.itsTransforms = (Transforms)xStream.fromXML(file);
            if (this.itsTransforms != null && this.itsTransforms.Transforms != null) {
                Util_Logger.info(logger, "Loaded " + this.itsTransforms.Transforms.size() + " JSON transforms from " + string);
                for (Transform transform : this.itsTransforms.Transforms) {
                    if (Util.isBlank(transform.Id)) {
                        throw new Exception("Missing Id attribute in JSON transforn definition file " + string);
                    }
                    if (Util.isBlank(transform.Json)) {
                        throw new Exception("Missing JSON attribute in JSON transforn definition file " + string);
                    }
                    JsonObject jsonObject = JsonUtilities.getJsonObjectFromString(transform.Json);
                    JsonUtilities jsonUtilities = new JsonUtilities();
                    jsonObject.addProperty("__Id", "$");
                    jsonUtilities.walkJsonDocumentTree((JsonElement)jsonObject, null, jsonObject, false);
                    transform.JsonObj = jsonObject;
                }
            }
        }
    }

    public JsonObject getTransform(String string, String string2) throws Exception {
        JsonObject jsonObject = null;
        Transform transform = null;
        if (this.itsTransforms != null && this.itsTransforms.Transforms != null) {
            for (Transform transform2 : this.itsTransforms.Transforms) {
                if (!transform2.Id.equalsIgnoreCase(string2)) continue;
                if (Util.isBlank(transform2.Scope)) {
                    transform = transform2;
                    break;
                }
                if (!transform2.Scope.equalsIgnoreCase(string)) continue;
                transform = transform2;
                break;
            }
        }
        if (transform == null) {
            throw new Exception("Unable to find JSON transform with specification Id [" + string2 + "] and Scope [" + string + "]");
        }
        jsonObject = transform.JsonObj;
        return jsonObject;
    }

    private static class SingletonHolder {
        private static JsonTransformManager instance = new JsonTransformManager();

        private SingletonHolder() {
        }
    }
}

