/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.JSON;

import au.com.aemo.Common.JSON.JsonTransformSpecViaLookup;
import au.com.aemo.Common.Java.Util;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Population via JSON seralisation")
public class JsonTransformSpecVia {
    public String type;
    public String sourceFormat;
    public String format;
    public List<JsonTransformSpecViaLookup> lookup;
    public String find;
    public String with;
    public String text;
    public JsonTransformSpecVia via;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String transformSourceValue(String string, Map<String, Object> map) throws Exception {
        Object object = null;
        if (this.type.equalsIgnoreCase("date")) {
            if (this.sourceFormat == null) {
                throw new IllegalArgumentException("Missing sourceFormat attribute for date JSON transformation");
            }
            if (this.format == null) {
                throw new IllegalArgumentException("Missing format attribute for date JSON transformation");
            }
            Date date = Util.strToDate(string, this.sourceFormat);
            object = Util.dateToStr(date, this.format);
        } else if (this.type.equalsIgnoreCase("case")) {
            if (this.lookup == null) throw new IllegalArgumentException("Missing lookup array for case JSON transformation");
            for (JsonTransformSpecViaLookup jsonTransformSpecViaLookup : this.lookup) {
                if (jsonTransformSpecViaLookup.from == null) {
                    throw new IllegalArgumentException("Missing from attribute for case JSON transformation");
                }
                if (!jsonTransformSpecViaLookup.from.equalsIgnoreCase(string)) continue;
                object = jsonTransformSpecViaLookup.to;
                break;
            }
            if (object == null) {
                throw new Exception("Invalid source value [" + string + "] detected in JSON lookup transformation");
            }
        } else if (this.type.equalsIgnoreCase("replace")) {
            if (this.find == null) {
                throw new IllegalArgumentException("Missing find attribute for replace JSON transformation");
            }
            if (this.with == null) {
                throw new IllegalArgumentException("Missing with attribute for replace JSON transformation");
            }
            object = Util.replaceAll(string, this.find, this.with);
        } else {
            if (!this.type.equalsIgnoreCase("append")) throw new IllegalArgumentException("Unsupported transform type [" + this.type + "]");
            if (this.text == null) {
                throw new IllegalArgumentException("Missing text attribute for append JSON transformation");
            }
            object = string + this.text;
        }
        if (this.via == null) return object;
        return this.via.transformSourceValue((String)object, map);
    }
}

