/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Jobs;

import au.com.aemo.Common.Jobs.JobTaskInt;
import au.com.aemo.Common.Jobs.LockEngineInt;
import au.com.aemo.Common.Jobs.LockManagerConfig;
import au.com.aemo.Common.Jobs.distributedLock;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Network.DistributedMessagingManager;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockEngineDistributed
implements LockEngineInt,
MessageListener<JobTaskInt> {
    public static final String MESSAGE_TOPIC_COMPLETION = "PDR_JOB_COMPLETION_NOTIFICATION";
    private static Logger logger = LoggerFactory.getLogger(LockEngineDistributed.class);
    private volatile Map<String, distributedLock> itsLocks = new ConcurrentHashMap<String, distributedLock>();
    private volatile Map<String, JobTaskInt> itsLocalTasks = new ConcurrentHashMap<String, JobTaskInt>();
    private ITopic<JobTaskInt> itsCompletionMessage;
    private boolean PriorityBumpEnabled;

    @Override
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="this method only called at initialisation")
    public void initialise(LockManagerConfig lockManagerConfig) {
        DistributedMessagingManager distributedMessagingManager = DistributedMessagingManager.getInstance();
        this.itsCompletionMessage = distributedMessagingManager.getAgent().getTopic(MESSAGE_TOPIC_COMPLETION);
        this.itsCompletionMessage.addMessageListener((MessageListener)this);
        this.PriorityBumpEnabled = lockManagerConfig.PriorityBumpEnabled;
    }

    public void onMessage(Message<JobTaskInt> message) {
        try {
            JobTaskInt jobTaskInt = (JobTaskInt)message.getMessageObject();
            if (!message.getPublishingMember().localMember()) {
                JobTaskInt jobTaskInt2;
                Util_Logger.debug(logger, "detected remote process message for file " + jobTaskInt.getName() + " status of " + jobTaskInt.getIsComplete() + " from " + String.valueOf(message.getPublishingMember()));
                if (jobTaskInt.getIsComplete() && (jobTaskInt2 = this.itsLocalTasks.get(jobTaskInt.getName())) != null) {
                    jobTaskInt2.setIsComplete(true);
                }
            } else {
                Util_Logger.debug(logger, "detected local process message for file " + jobTaskInt.getName() + " status of " + jobTaskInt.getIsComplete() + " from " + String.valueOf(message.getPublishingMember()));
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Unable to process job completion message: " + exception.getMessage(), exception);
        }
    }

    @Override
    public synchronized boolean addTask(String string, JobTaskInt jobTaskInt) {
        DistributedMessagingManager distributedMessagingManager;
        Object object;
        Util_Logger.debug(logger, "Lock Manager request for exclusive lock on " + string);
        if (jobTaskInt != null) {
            this.itsLocalTasks.putIfAbsent(jobTaskInt.getName(), jobTaskInt);
        }
        ArrayList<distributedLock> arrayList = new ArrayList<distributedLock>(this.itsLocks.values());
        boolean bl = false;
        if (jobTaskInt == null) {
            bl = true;
        } else {
            bl = !jobTaskInt.getIsComplete();
            for (distributedLock object22 : arrayList) {
                object = object22.itsTask;
                if (object == null || object.getPriority() >= jobTaskInt.getPriority()) continue;
                Util_Logger.debug(logger, "Lock Manager does not allow a priority " + jobTaskInt.getPriority() + " task (" + jobTaskInt.getFilename() + ") to start if a priority " + object.getPriority() + " (" + object.getFilename() + ") task is being processed");
                bl = false;
            }
        }
        boolean bl2 = false;
        if (bl && (object = (distributedMessagingManager = DistributedMessagingManager.getInstance()).getAgent().getCPSubsystem().getLock(string)).tryLock()) {
            bl2 = true;
            distributedLock distributedLock2 = new distributedLock();
            distributedLock2.itsLockEntity = string;
            distributedLock2.itsFencedLock = object;
            distributedLock2.itsTask = jobTaskInt;
            distributedLock2.itsThread = Thread.currentThread();
            this.itsLocks.put(string, distributedLock2);
            if (jobTaskInt != null) {
                if (this.PriorityBumpEnabled) {
                    for (distributedLock distributedLock3 : arrayList) {
                        JobTaskInt jobTaskInt2 = distributedLock3.itsTask;
                        if (jobTaskInt2 == null || jobTaskInt2.getPriority() <= jobTaskInt.getPriority()) continue;
                        Util_Logger.debug(logger, "Lock Manager sending bump signal to low priority task " + jobTaskInt2.getFilename());
                        jobTaskInt2.setIsPriorityBumping(true);
                    }
                }
                jobTaskInt.setIsAllocated(true);
                jobTaskInt.setIsPriorityBumped(false);
                jobTaskInt.setIsPriorityBumping(false);
                jobTaskInt.setPKViolationDetected(false);
            }
        }
        if (bl2) {
            Util_Logger.debug(logger, "Lock Manager accepted request for exclusive lock on " + string);
        }
        Util_Logger.debug(logger, "Lock Manager contains " + this.itsLocks.size() + " entries");
        return bl2;
    }

    @Override
    public void deleteTask(String string) {
        Util_Logger.debug(logger, "Lock Manager release exclusive lock on " + string);
        distributedLock distributedLock2 = this.itsLocks.get(string);
        if (distributedLock2 != null) {
            JobTaskInt jobTaskInt = distributedLock2.itsTask;
            if (jobTaskInt != null) {
                jobTaskInt.setIsAllocated(false);
                this.itsLocalTasks.remove(jobTaskInt.getName());
                if (jobTaskInt.getIsComplete() && jobTaskInt.sendCompletionMessage()) {
                    this.itsCompletionMessage.publish((Object)jobTaskInt);
                }
            }
            distributedLock2.itsFencedLock.unlock();
            this.itsLocks.remove(string);
            Util_Logger.debug(logger, "Lock Manager contains " + this.itsLocks.size() + " entries");
        }
    }

    @Override
    public void cleanQueue(Thread thread) {
        ArrayList<distributedLock> arrayList = new ArrayList<distributedLock>(this.itsLocks.values());
        for (distributedLock distributedLock2 : arrayList) {
            Thread thread2 = distributedLock2.itsThread;
            if (thread2 == null || !thread2.getName().equalsIgnoreCase(thread.getName())) continue;
            this.deleteTask(distributedLock2.itsLockEntity);
            Util_Logger.warning(logger, "Removing lock " + distributedLock2.itsLockEntity + " from lock manager due to dead thread " + thread.getName());
        }
    }
}

