/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Network;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Network.DistributedMessagingConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.properties.ClusterProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedMessagingManager {
    private static Logger logger = LoggerFactory.getLogger(DistributedMessagingManager.class);
    private HazelcastInstance itsAgent;
    private DistributedMessagingConfig itsConfig;
    private boolean itsIsEnabled = false;

    private DistributedMessagingManager() {
    }

    public static DistributedMessagingManager getInstance() {
        return SingletonHolder.instance;
    }

    public static DistributedMessagingConfig loadConfigFromProperties(Properties properties) {
        DistributedMessagingConfig distributedMessagingConfig = new DistributedMessagingConfig();
        distributedMessagingConfig.ClusterName = Util.getProperty(properties, "distributed_messaging_cluster_name", null);
        distributedMessagingConfig.ConfigFile = Util.getProperty(properties, "distributed_messaging_config_file", null);
        return distributedMessagingConfig;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void init(DistributedMessagingConfig distributedMessagingConfig) {
        if (distributedMessagingConfig != null) {
            this.itsConfig = distributedMessagingConfig;
            this.itsIsEnabled = !Util.isBlank(distributedMessagingConfig.ClusterName);
        }
    }

    public boolean isEnabled() {
        return this.itsIsEnabled;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Required by distributed lock manager")
    public HazelcastInstance getAgent() {
        return this.itsAgent;
    }

    public void start() throws ApplicationException {
        try {
            if (this.itsIsEnabled) {
                Util_Logger.info(logger, "Starting distributed messaging");
                Config config = new Config();
                if (!Util.isBlank(this.itsConfig.ConfigFile)) {
                    if (this.itsConfig.ConfigFile.toLowerCase().endsWith("xml")) {
                        XmlConfigBuilder xmlConfigBuilder = new XmlConfigBuilder(this.itsConfig.ConfigFile);
                        config = xmlConfigBuilder.build();
                    } else if (this.itsConfig.ConfigFile.toLowerCase().endsWith("yaml")) {
                        YamlConfigBuilder yamlConfigBuilder = new YamlConfigBuilder(this.itsConfig.ConfigFile);
                        config = yamlConfigBuilder.build();
                    } else {
                        throw new Exception("Unsupported configuration file type: " + this.itsConfig.ConfigFile);
                    }
                }
                if (!Util.isBlank(this.itsConfig.ClusterName)) {
                    config.setClusterName(this.itsConfig.ClusterName);
                }
                config.setProperty(ClusterProperty.SHUTDOWNHOOK_ENABLED.getName(), "false");
                config.setProperty(ClusterProperty.LOGGING_TYPE.getName(), "slf4j");
                this.itsAgent = Hazelcast.newHazelcastInstance((Config)config);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error starting distributed messaging: " + exception.getMessage(), exception);
        }
    }

    public void stop() {
        try {
            if (this.itsAgent != null) {
                this.itsAgent.shutdown();
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error stopping distributed messaging: " + exception.getMessage(), exception);
        }
    }

    private static class SingletonHolder {
        private static DistributedMessagingManager instance = new DistributedMessagingManager();

        private SingletonHolder() {
        }
    }
}

