/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClientAuthInt;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.aemo.Common.Zip.ZipUtilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClient {
    private static Logger logger = LoggerFactory.getLogger(WebClient.class);
    private Proxy itsProxy;
    private Integer itsTimeoutConnectionSecs;
    private Integer itsTimeoutTransferSecs;
    private UUID itsUUID;
    private String itsUsername;
    private String itsPassword;
    private WebClientAuthInt itsAuthProvider;
    private boolean itsUseDefaultSSLContext = true;

    public WebClient setTimeoutConnectionSecs(Integer n) {
        this.itsTimeoutConnectionSecs = n;
        return this;
    }

    public WebClient setTimeoutTransferSecs(Integer n) {
        this.itsTimeoutTransferSecs = n;
        return this;
    }

    public WebClient setProxy(String string, Integer n) {
        if (!Util.isBlank(string)) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, (int)n);
            this.itsProxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
        }
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public WebClient setProxy(Proxy proxy) {
        this.itsProxy = proxy;
        return this;
    }

    public WebClient setUseDefaultSSLContext(boolean bl) {
        this.itsUseDefaultSSLContext = bl;
        return this;
    }

    public UUID getUUID() {
        return this.itsUUID;
    }

    public void setUUID(UUID uUID) {
        this.itsUUID = uUID;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public WebClient setAuthProvider(WebClientAuthInt webClientAuthInt) {
        this.itsAuthProvider = webClientAuthInt;
        return this;
    }

    public void setBasicAuthDetails(String string, String string2) {
        if (!Util.isBlank(string) && !Util.isBlank(string2)) {
            this.itsUsername = string;
            this.itsPassword = string2;
        }
    }

    public void setAPIAuthDetails(String string) {
        if (!Util.isBlank(string)) {
            // empty if block
        }
    }

    public HttpURLConnection getHttpURLConnection(String string, URL uRL, Map<String, String> map) throws ApplicationException {
        HttpURLConnection httpURLConnection = null;
        try {
            boolean bl = uRL.getProtocol().equalsIgnoreCase("https");
            httpURLConnection = bl ? (this.itsProxy == null ? (HttpsURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpsURLConnection)uRL.openConnection(this.itsProxy)) : (this.itsProxy == null ? (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)uRL.openConnection(this.itsProxy));
            httpURLConnection.setRequestMethod(string);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(string.equalsIgnoreCase("POST") || string.equalsIgnoreCase("PUT"));
            if (this.itsTimeoutConnectionSecs != null) {
                httpURLConnection.setConnectTimeout(this.itsTimeoutConnectionSecs * 1000);
            }
            if (this.itsTimeoutTransferSecs != null) {
                httpURLConnection.setReadTimeout(this.itsTimeoutTransferSecs * 1000);
            }
            httpURLConnection.setUseCaches(false);
            if (bl) {
                if (this.itsUseDefaultSSLContext) {
                    Util_Logger.debug(logger, "Using default JRE key store to connect to: " + uRL.getPath());
                } else {
                    Util_Logger.debug(logger, "Using client key store to connect to: " + uRL.getPath());
                    SSLContext sSLContext = CertificateManager.getInstance().getSslContext();
                    ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sSLContext.getSocketFactory());
                }
            }
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.error(logger, "Error connecting to HTTP URL " + uRL.toString() + ": " + exception.getMessage(), exception);
        }
        return httpURLConnection;
    }

    @SuppressFBWarnings(value={"DM_STRING_CTOR"}, justification="Avoid holding object references")
    public WebHttpResponse readResponse(HttpURLConnection httpURLConnection) throws IOException {
        BufferedReader bufferedReader;
        WebHttpResponse webHttpResponse = new WebHttpResponse();
        webHttpResponse.ReturnCode = httpURLConnection.getResponseCode();
        if (!Util.isBlank(httpURLConnection.getContentType())) {
            webHttpResponse.ContentType = new String(httpURLConnection.getContentType());
        }
        String string = httpURLConnection.getContentEncoding();
        if (httpURLConnection.getResponseCode() == 200) {
            if (Util.isBlank(string)) {
                try (BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                    webHttpResponse.Body = bufferedReader2.lines().collect(Collectors.joining("\n"));
                }
            }
            if (string.equalsIgnoreCase("gzip")) {
                try (BufferedReader bufferedReader3 = new BufferedReader(new InputStreamReader(new GZIPInputStream(httpURLConnection.getInputStream())));){
                    webHttpResponse.Body = bufferedReader3.lines().collect(Collectors.joining("\n"));
                }
            }
            throw new IOException("Unsupported Content-Encoding in web response [" + string + "]");
        }
        if (httpURLConnection.getErrorStream() != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
            try {
                webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
            }
            finally {
                bufferedReader.close();
            }
        }
        if (Util.isBlank(webHttpResponse.Body) && httpURLConnection.getInputStream() != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            try {
                webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
            }
            finally {
                bufferedReader.close();
            }
        }
        if (Util.isBlank(webHttpResponse.Body)) {
            webHttpResponse.Body = httpURLConnection.getResponseMessage();
        }
        return webHttpResponse;
    }

    public WebHttpResponse doGet(String string, Map<String, String> map) throws ApplicationException {
        WebHttpResponse webHttpResponse = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = this.itsAuthProvider.updateURL(string);
            httpURLConnection = this.getHttpURLConnection("GET", uRL, map);
            this.itsAuthProvider.addAuthentication(httpURLConnection, null);
            if (this.itsUUID != null) {
                httpURLConnection.setRequestProperty("X-UUID", this.itsUUID.toString());
            }
            httpURLConnection.connect();
            webHttpResponse = this.readResponse(httpURLConnection);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring HTTP request from " + string + ": " + exception.getMessage(), exception);
        }
        if (!Util.isBlank(webHttpResponse.Body)) {
            Util_Logger.debug(logger, "API response body is " + webHttpResponse.Body);
        }
        return webHttpResponse;
    }

    public WebHttpResponse doPost(String string, Map<String, String> map, WebContent.MediaType mediaType, String string2) throws ApplicationException {
        WebHttpResponse webHttpResponse = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = this.itsAuthProvider.updateURL(string);
            httpURLConnection = this.getHttpURLConnection("POST", uRL, map);
            this.itsAuthProvider.addAuthentication(httpURLConnection, string2);
            if (this.itsUUID != null) {
                httpURLConnection.setRequestProperty("X-UUID", this.itsUUID.toString());
            }
            String string3 = null;
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!entry.getKey().equalsIgnoreCase("Content-Encoding")) continue;
                    string3 = (String)entry.getValue();
                }
            }
            Object object = null;
            if (Util.isBlank(string3)) {
                object = string2.getBytes();
            } else if (string3.equalsIgnoreCase("gzip")) {
                Map.Entry<String, String> entry;
                entry = new ByteArrayOutputStream();
                try {
                    ZipUtilities.gzip(new ByteArrayInputStream(string2.getBytes()), (OutputStream)((Object)entry));
                    object = ((ByteArrayOutputStream)((Object)entry)).toByteArray();
                }
                finally {
                    ((ByteArrayOutputStream)((Object)entry)).close();
                }
            } else {
                throw new IOException("Unsupported Content-Encoding [" + string3 + "] is web POST");
            }
            httpURLConnection.setRequestProperty("Content-Type", mediaType.toString().replace('_', '/'));
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(((Object)object).length));
            httpURLConnection.getOutputStream().write((byte[])object);
            httpURLConnection.connect();
            webHttpResponse = this.readResponse(httpURLConnection);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring data to " + string + ": " + exception.getMessage(), exception);
        }
        if (!Util.isBlank(webHttpResponse.Body)) {
            Util_Logger.debug(logger, "API response body is " + webHttpResponse.Body);
        }
        return webHttpResponse;
    }

    public WebSocket connectToWebSocket(String string, Map<String, String> map, WebSocket.Listener listener) throws Exception {
        Object object;
        HttpClient.Builder builder = HttpClient.newBuilder();
        boolean bl = string.toLowerCase().startsWith("wss://");
        if (bl && !this.itsUseDefaultSSLContext) {
            object = CertificateManager.getInstance().getSslContext();
            builder = builder.sslContext((SSLContext)object);
        }
        if (this.itsTimeoutConnectionSecs != null) {
            builder = builder.connectTimeout(Duration.ofSeconds(this.itsTimeoutConnectionSecs.intValue()));
        }
        if (this.itsProxy != null) {
            builder = builder.proxy(ProxySelector.of((InetSocketAddress)this.itsProxy.address()));
        }
        object = builder.build().newWebSocketBuilder();
        if (map != null) {
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                object.header(object2.getKey(), object2.getValue());
            }
        }
        if (this.itsAuthProvider != null) {
            Map<String, String> map2 = this.itsAuthProvider.getAuthenticationHeaders(null, null);
            for (Map.Entry entry : map2.entrySet()) {
                object.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return object.buildAsync(URI.create(string), listener).join();
    }
}

