/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebExecutionParams;
import au.com.aemo.Common.Web.WebParamValidationConfig;
import au.com.aemo.Common.Web.WebSecurityAuthenticationEnum;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Utility class consumed by trusted code, encapsulation of properties is not really required")
public class WebHandlerAPIWrapperMethod {
    private static Logger logger = LoggerFactory.getLogger(WebHandlerAPIWrapperMethod.class);
    public String path;
    public String[] URIParts;
    public Method method;
    public Class clazz;
    public WebSecurityAuthenticationEnum auth;
    public AuthorisationActionEnum action;
    public String AuthContext;
    public String contentType;
    public boolean AdminAccessOnly;
    public Map<String, Integer> urlPathParamNames = new HashMap<String, Integer>();
    public List<WebParamValidationConfig> methodParams = new ArrayList<WebParamValidationConfig>();

    public void setPath(String string) {
        this.path = string;
        this.URIParts = this.path.split("/");
        this.urlPathParamNames.clear();
        int n = 0;
        for (String string2 : this.URIParts) {
            if (this.isParameter(string2)) {
                Util_Logger.debug(logger, "Adding URL parameter [" + this.getParameterName(string2) + "] at position [" + n + "] in URL");
                this.urlPathParamNames.put(this.getParameterName(string2), n);
            }
            ++n;
        }
    }

    private boolean isParameter(String string) {
        return string.startsWith("${") && string.endsWith("}");
    }

    private String getParameterName(String string) {
        String string2 = string.substring(2, string.length() - 1);
        return string2;
    }

    protected int getNonParameterURICountMatch(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < this.URIParts.length; ++i) {
            if (this.isParameter(this.URIParts[i]) || i >= stringArray.length || !this.URIParts[i].equalsIgnoreCase(stringArray[i])) continue;
            ++n;
        }
        return n;
    }

    protected String getPath() {
        return this.path;
    }

    public WebExecutionParams matches(String[] stringArray, Map<String, String> map) {
        WebExecutionParams webExecutionParams = new WebExecutionParams();
        webExecutionParams.Matches = false;
        if (stringArray.length >= this.URIParts.length) {
            boolean bl;
            boolean bl2 = true;
            for (bl = false; bl < this.URIParts.length; bl += 1) {
                if (this.isParameter(this.URIParts[bl]) || stringArray[bl].equalsIgnoreCase(this.URIParts[bl])) continue;
                bl2 = false;
            }
            Util_Logger.debug(logger, "URL match status is [" + bl2 + "]");
            bl = false;
            if (this.methodParams == null) {
                bl = true;
            } else if (this.methodParams.size() == 0) {
                bl = true;
            } else {
                bl = true;
                for (WebParamValidationConfig webParamValidationConfig : this.methodParams) {
                    boolean bl3 = false;
                    if (map.containsKey(webParamValidationConfig.getSource())) {
                        bl3 = true;
                        webExecutionParams.Params.put(webParamValidationConfig.getSource(), map.get(webParamValidationConfig.getSource()));
                    } else if (this.urlPathParamNames.containsKey(webParamValidationConfig.getSource())) {
                        bl3 = true;
                        int n = this.urlPathParamNames.get(webParamValidationConfig.getSource());
                        webExecutionParams.Params.put(webParamValidationConfig.getSource(), stringArray[n]);
                    }
                    Util_Logger.debug(logger, (webParamValidationConfig.isMandatory() ? "Mandatory" : "Optional") + " method parameter [" + webParamValidationConfig.getName() + "] with source [" + webParamValidationConfig.getSource() + "] found status is " + bl3);
                    if (!webParamValidationConfig.isMandatory() || bl3) continue;
                    bl = false;
                }
            }
            Util_Logger.debug(logger, "Method parameter match status is [" + bl + "]");
            webExecutionParams.Matches = bl2 && bl;
        }
        return webExecutionParams;
    }

    public String getAuthContextURLParameter(String[] stringArray) {
        String string = null;
        if (!Util.isBlank(this.AuthContext) && this.urlPathParamNames.containsKey(this.AuthContext)) {
            int n = this.urlPathParamNames.get(this.AuthContext);
            string = stringArray[n];
        }
        return string;
    }
}

