/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Certificate.CertificateStoreConfig;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebServerConfigIPAddress;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@XStreamAlias(value="WebServer")
@SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Configuration class consumed by trusted code, encapsulation of properties is not really required")
public class WebServerConfig {
    public int Port;
    public Boolean EnableAuthentication;
    public String API_KEY;
    public Date keyFileLastModifiedDate;
    public Integer TimeDriftToleranceSeconds;
    public String WWW_Root;
    public String WWW_Index;
    public Boolean WebDocumentEnableCache;
    public Boolean WebDocumentEnableSSI;
    public Boolean WebServiceCatalogEnable;
    public Integer NoThreads;
    public String ResponseHeaders;
    public CertificateStoreConfig HTTPS;
    public List<WebServerConfigIPAddress> Hosts = new ArrayList<WebServerConfigIPAddress>();

    public WebServerConfig() {
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        if (this.WebDocumentEnableCache == null) {
            this.WebDocumentEnableCache = true;
        }
        if (this.WebDocumentEnableSSI == null) {
            this.WebDocumentEnableSSI = true;
        }
        if (this.NoThreads == null) {
            this.NoThreads = 10;
        }
        if (this.WebServiceCatalogEnable == null) {
            this.WebServiceCatalogEnable = true;
        }
        if (this.TimeDriftToleranceSeconds == null) {
            this.TimeDriftToleranceSeconds = 60;
        }
        if (this.EnableAuthentication == null) {
            this.EnableAuthentication = true;
        }
    }

    public boolean getHttpProtocol() {
        if (this.HTTPS == null) {
            return true;
        }
        return Util.isBlank(this.HTTPS.KeyStoreFile);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.setDefaultValues();
        return this;
    }
}

