/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Savepoint;
import java.sql.Statement;

public class ScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean stopOnError;
    private boolean autoCommit;
    private boolean debug;
    private PrintWriter logWriter = new PrintWriter(System.out);
    private PrintWriter errorLogWriter = new PrintWriter(System.err);
    private String delimiter = ";";
    private String fullLineDelimiter;
    private boolean ignorePKViolations = false;

    public ScriptRunner(Connection connection, boolean bl, boolean bl2) {
        this.connection = connection;
        this.autoCommit = bl;
        this.stopOnError = bl2;
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public void setIgnorePKViolations(boolean bl) {
        this.ignorePKViolations = bl;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setFullLineDelimiter(String string) {
        this.fullLineDelimiter = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setErrorLogWriter(PrintWriter printWriter) {
        this.errorLogWriter = printWriter;
    }

    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            boolean bl = this.connection.getAutoCommit();
            try {
                if (bl != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(bl);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error running script.  Cause: " + String.valueOf(exception), exception);
        }
    }

    private boolean reportError(SQLException sQLException) {
        boolean bl = true;
        if (this.ignorePKViolations) {
            if (sQLException instanceof SQLIntegrityConstraintViolationException) {
                bl = false;
            } else if (sQLException.getSQLState().equalsIgnoreCase("23000") || sQLException.getSQLState().equalsIgnoreCase("23505")) {
                bl = false;
            }
        }
        return bl;
    }

    private String extractSqlCommand(String string) {
        String string2 = null;
        if (this.delimiter != null && string.endsWith(this.delimiter)) {
            string2 = string.substring(0, string.lastIndexOf(this.delimiter));
        }
        if (this.fullLineDelimiter != null && string.equals(this.fullLineDelimiter)) {
            string2 = string.substring(0, string.lastIndexOf(this.fullLineDelimiter));
        }
        return string2;
    }

    private void runScript(Connection connection, Reader reader) throws IOException, SQLException {
        StringBuffer stringBuffer = null;
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(reader);
            String string = null;
            String string2 = null;
            while ((string = lineNumberReader.readLine()) != null) {
                String string3;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                if ((string3 = string.trim()).startsWith("--")) {
                    this.println(string3);
                    continue;
                }
                if (string3.length() < 1) continue;
                if (string3.startsWith("//")) {
                    this.println(string3);
                    continue;
                }
                if (string3.startsWith("--")) {
                    this.println(string3);
                    continue;
                }
                if (string3.startsWith("/*")) {
                    this.println(string3);
                    continue;
                }
                string2 = this.extractSqlCommand(string3);
                if (string2 != null) {
                    boolean bl;
                    Statement statement;
                    block32: {
                        stringBuffer.append(string2);
                        stringBuffer.append(" ");
                        statement = connection.createStatement();
                        Savepoint savepoint = null;
                        try {
                            savepoint = connection.setSavepoint();
                        }
                        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                            // empty catch block
                        }
                        String string4 = stringBuffer.toString();
                        this.println(string4);
                        bl = false;
                        if (this.stopOnError) {
                            try {
                                bl = statement.execute(string4);
                            }
                            catch (SQLException sQLException) {
                                if (this.reportError(sQLException)) {
                                    throw sQLException;
                                }
                                if (savepoint != null) {
                                    connection.rollback(savepoint);
                                }
                                break block32;
                            }
                        }
                        try {
                            statement.execute(stringBuffer.toString());
                        }
                        catch (SQLException sQLException) {
                            boolean bl2 = this.reportError(sQLException);
                            if (bl2) {
                                sQLException.fillInStackTrace();
                                this.printlnError("Error executing: " + String.valueOf(stringBuffer));
                                this.printlnError(sQLException);
                            }
                            if (savepoint == null) break block32;
                            connection.rollback(savepoint);
                        }
                    }
                    if (this.autoCommit && !connection.getAutoCommit()) {
                        connection.commit();
                    }
                    ResultSet resultSet = statement.getResultSet();
                    if (bl && resultSet != null) {
                        String string5;
                        int n;
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        int n2 = resultSetMetaData.getColumnCount();
                        for (n = 1; n <= n2; ++n) {
                            string5 = resultSetMetaData.getColumnLabel(n);
                            this.print(string5 + "\t");
                        }
                        this.println("");
                        while (resultSet.next()) {
                            for (n = 1; n <= n2; ++n) {
                                string5 = resultSet.getString(n);
                                this.print(string5 + "\t");
                            }
                            this.println("");
                        }
                    }
                    stringBuffer = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            if (!this.autoCommit) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            this.printlnError("Error executing: " + String.valueOf(stringBuffer));
            this.printlnError(sQLException);
            throw sQLException;
        }
        catch (IOException iOException) {
            iOException.fillInStackTrace();
            this.printlnError("Error executing: " + String.valueOf(stringBuffer));
            this.printlnError(iOException);
            throw iOException;
        }
        finally {
            if (!this.autoCommit) {
                connection.rollback();
            }
            this.flush();
        }
    }

    private void print(Object object) {
        if (this.logWriter != null) {
            this.logWriter.print(object);
        }
    }

    private void println(Object object) {
        if (this.logWriter != null) {
            this.logWriter.println(object);
        }
    }

    private void printlnError(Object object) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(object);
        }
    }

    private void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
        if (this.errorLogWriter != null) {
            this.errorLogWriter.flush();
        }
    }
}

