/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class installationDirectoryBackup
implements PanelAction {
    private static final Logger logger = Logger.getLogger(installationDirectoryBackup.class.getName());
    private String foldersToBackup;

    @Override
    public void initialize(PanelActionConfiguration panelActionConfiguration) {
        logger.log(Level.CONFIG, "installationDirectoryBackup: Initializing.");
        if (panelActionConfiguration == null) {
            logger.log(Level.CONFIG, "installationDirectoryBackup: Initialization failed.");
        } else {
            this.foldersToBackup = panelActionConfiguration.getProperty("foldersToBackup", null);
            logger.log(Level.CONFIG, "installationDirectoryBackup: Initialization variable foldersToBackup=" + this.foldersToBackup);
        }
    }

    public void copyFolder(File file, File file2) {
        if (file == null || file2 == null) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                return;
            }
        } else {
            file2.mkdirs();
        }
        if (file.listFiles() == null || file.listFiles().length == 0) {
            return;
        }
        for (File file3 : file.listFiles()) {
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                this.copyFolder(file3, file4);
                continue;
            }
            if (file4.exists()) continue;
            try {
                Files.copy(file3.toPath(), file4.toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler abstractUIHandler) {
        logger.log(Level.CONFIG, "installationDirectoryBackup: Starting");
        String string = installData.getInstallPath();
        String string2 = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String string3 = string + "_" + string2;
        if (this.foldersToBackup != null) {
            for (String string4 : this.foldersToBackup.split(",")) {
                if (string4 == null || string4.length() <= 0) continue;
                logger.log(Level.CONFIG, "installationDirectoryBackup: Backing up subdirectory " + string4);
                this.copyFolder(new File(string, string4), new File(string3, string4));
            }
        }
        installData.setVariable("BACKUP_DIR", string3);
        logger.log(Level.CONFIG, "installationDirectoryBackup: Completed");
    }

    public static void main(String[] stringArray) throws Exception {
        installationDirectoryBackup installationDirectoryBackup2 = new installationDirectoryBackup();
        installationDirectoryBackup2.copyFolder(new File(stringArray[0]), new File(stringArray[1]));
    }
}

