/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Common.Monitor.pdrLoggerRec;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorManager;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorRec;
import java.util.ArrayList;
import java.util.Date;

@WebPath(value="/api/logger")
public class WebAPILogger {
    @WebGET(Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getMonitorLogs(@WebParam(source="ackFilter", mandatory=false, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="startDate", mandatory=false, validatorParam=WebParamValidationEnum.DATE) Date date, @WebParam(source="endDate", mandatory=false, validatorParam=WebParamValidationEnum.DATE) Date date2) throws Exception {
        pdrMonitorManager pdrMonitorManager2 = pdrMonitorManager.getInstance();
        ArrayList<pdrMonitorRec> arrayList = new ArrayList<pdrMonitorRec>(pdrMonitorManager2.getCurrentLogRecs());
        ArrayList<pdrLoggerRec> arrayList2 = new ArrayList<pdrLoggerRec>();
        for (pdrLoggerRec pdrLoggerRec4 : arrayList) {
            boolean bl = true;
            if (!Util.isBlank(string)) {
                if (string.equalsIgnoreCase("Unacknowledged")) {
                    bl = !pdrLoggerRec4.isAcknowledged();
                } else if (string.equalsIgnoreCase("Acknowledged")) {
                    bl = pdrLoggerRec4.isAcknowledged();
                } else if (!string.equalsIgnoreCase("All")) {
                    throw new Exception("Invalid logging filter [" + string + "]");
                }
            }
            if (date != null && pdrLoggerRec4.getEventDate().before(date)) {
                bl = false;
            }
            if (date2 != null && pdrLoggerRec4.getEventDate().after(Util.dateOffset(date2, 1, 5))) {
                bl = false;
            }
            if (!bl) continue;
            arrayList2.add(pdrLoggerRec4);
        }
        arrayList2.sort((pdrLoggerRec2, pdrLoggerRec3) -> pdrLoggerRec3.getEventDate().compareTo(pdrLoggerRec2.getEventDate()));
        return JsonUtilities.toJson(arrayList2);
    }
}

