/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebAPIBaseClass;
import au.com.aemo.Common.Web.WebParamValidationConfig;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebParameterHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceHelper
extends WebParameterHelper {
    private static Logger logger = LoggerFactory.getLogger(PerformanceHelper.class);
    public static final int MAX_JOB_DURATION_DAYS = 1;
    public Date startDateTime;
    public Date endDateTime;
    public Date clickDateTime;
    public int reportingInterval;
    public int chartScale;
    public int chartScale2;
    public List<String> fileIDList;
    public String filename;
    public boolean aggregatedData;
    public boolean forceRawData;
    public String jobType;
    public String confidentiality;
    public String dataSource;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Class is only used by internal trusted code")
    public PerformanceHelper(WebAPIBaseClass webAPIBaseClass) throws Exception {
        this.startDateTime = webAPIBaseClass.getParam(new WebParamValidationConfig("startDate").setValidatorParam(WebParamValidationEnum.DATE), Date.class);
        this.endDateTime = webAPIBaseClass.getParam(new WebParamValidationConfig("endDate").setValidatorParam(WebParamValidationEnum.DATE), Date.class);
        if (this.endDateTime != null) {
            this.endDateTime = Util.dateOffset(this.endDateTime, 1, 5);
        }
        this.clickDateTime = webAPIBaseClass.getParam(new WebParamValidationConfig("clickDate").setValidatorParam(WebParamValidationEnum.DATETIME), Date.class);
        this.chartScale = webAPIBaseClass.getParam(new WebParamValidationConfig("chartScale").setValidatorParam(WebParamValidationEnum.POSITIVE).setDefaultValue("1"), Integer.class);
        this.chartScale2 = webAPIBaseClass.getParam(new WebParamValidationConfig("chartScale2").setValidatorParam(WebParamValidationEnum.POSITIVE).setDefaultValue("1"), Integer.class);
        this.aggregatedData = false;
        boolean bl = false;
        this.reportingInterval = webAPIBaseClass.getParam(new WebParamValidationConfig("reportingInterval").setValidatorParam(WebParamValidationEnum.POSITIVE).setDefaultValue("1"), Integer.class);
        this.forceRawData = webAPIBaseClass.getParam(new WebParamValidationConfig("rawData").setValidatorParam(WebParamValidationEnum.BOOLEAN).setDefaultValue("true"), Boolean.class);
        this.filename = webAPIBaseClass.getParam(new WebParamValidationConfig("filename").setValidatorParam(WebParamValidationEnum.STR_FILEMASK), String.class);
        this.jobType = webAPIBaseClass.getParam(new WebParamValidationConfig("jobType").setValidatorParam(WebParamValidationEnum.STR_OBJECT_ID), String.class);
        this.dataSource = webAPIBaseClass.getParam(new WebParamValidationConfig("dataSource").setValidatorParam(WebParamValidationEnum.STR_OBJECT_ID), String.class);
        this.fileIDList = new ArrayList<String>();
        String string = webAPIBaseClass.getParam(new WebParamValidationConfig("fileIDList").setValidatorParam(WebParamValidationEnum.STR_COMMA_DELIMITED_LIST), String.class);
        if (!Util.isBlank(string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.toUpperCase().split(",")) {
                if (Util.isBlank(string2)) continue;
                this.fileIDList.add(string2);
                if (!string2.contains("*")) continue;
                bl = true;
            }
        }
        this.confidentiality = webAPIBaseClass.getParam(new WebParamValidationConfig("confidentiality").setValidatorParam(WebParamValidationEnum.STR_OBJECT_ID), String.class);
        if (this.startDateTime != null && this.endDateTime != null) {
            long l = this.endDateTime.getTime() - this.startDateTime.getTime() + 86400L;
            long l2 = TimeUnit.DAYS.convert(l, TimeUnit.MILLISECONDS);
            int n = 0;
            n = l2 <= 2L ? 5 : (l2 < 30L ? 60 : 1440);
            if (!this.forceRawData && this.reportingInterval < n) {
                Util_Logger.info(logger, "Limiting reporting output of application performance data detail from " + this.reportingInterval + " to " + n + " minute intervals");
                this.reportingInterval = n;
            }
        }
        this.aggregatedData = this.forceRawData ? false : (this.fileIDList.size() > 1 ? false : (bl ? false : this.reportingInterval > 5));
    }

    protected static String buildSQLPredicate(String string, String string2) {
        if (!Util.isBlank(string2)) {
            return PerformanceHelper.buildSQLPredicate(string, new ArrayList<String>(List.of(string2)));
        }
        return "";
    }

    protected static String buildSQLPredicate(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && list.size() > 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string2 = "";
            for (String object2 : list) {
                if (Util.isBlank(object2) || object2.contains("*")) continue;
                if (Util.isBlank(string2)) {
                    stringBuilder2.append(" ");
                    stringBuilder2.append(string);
                    stringBuilder2.append(" in (");
                } else {
                    stringBuilder2.append(string2);
                }
                stringBuilder2.append("'");
                stringBuilder2.append(object2);
                stringBuilder2.append("'");
                string2 = ",";
            }
            if (!Util.isBlank(string2)) {
                stringBuilder2.append(")");
            }
            StringBuilder stringBuilder3 = new StringBuilder();
            string2 = "";
            for (String string3 : list) {
                if (Util.isBlank(string3) || !string3.contains("*")) continue;
                stringBuilder3.append(string2);
                stringBuilder3.append(" ");
                stringBuilder3.append(string);
                stringBuilder3.append(" LIKE '");
                stringBuilder3.append(string3.replace('*', '%').replaceAll("_", "\\\\_"));
                stringBuilder3.append("' ESCAPE '\\'");
                string2 = " OR ";
            }
            StringBuilder stringBuilder4 = new StringBuilder();
            stringBuilder4.append((CharSequence)stringBuilder2);
            if (stringBuilder3.length() > 0) {
                if (stringBuilder4.length() > 0) {
                    stringBuilder4.append(" OR ");
                }
                stringBuilder4.append((CharSequence)stringBuilder3);
            }
            if (stringBuilder4.length() > 0) {
                stringBuilder.append(" AND (");
                stringBuilder.append((CharSequence)stringBuilder4);
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString();
    }
}

