/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/system/${system}/${application}/${instanceId}/congestion")
public class WebAPIApplicationCongestion {
    private static Logger logger = LoggerFactory.getLogger(WebAPIApplicationCongestion.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getApplicationCongestion(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n, @WebParam(source="AsAtDate", mandatory=true, validatorParam=WebParamValidationEnum.DATE) Date date) throws Exception {
        String string4 = null;
        TreeMap<String, congestionRec> treeMap = new TreeMap<String, congestionRec>();
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
            List<pdrMonitorSource> list = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
            Date date2 = Util.dateOffset(date, 1, 5);
            DbHandler dbHandler = DbManager.getDbHandler();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select");
            stringBuilder.append(" p1.FILE_ID");
            stringBuilder.append(" ,count(1) as TOTAL_FILEID_COUNT");
            stringBuilder.append(" from PDR_MONITOR_PERFORMANCE p1");
            stringBuilder.append(" where p1.PDR_MONITOR_ID in (");
            String string5 = "";
            for (pdrMonitorSource object2 : list) {
                stringBuilder.append(string5);
                stringBuilder.append(object2.pdr_monitor_id);
                string5 = ",";
            }
            stringBuilder.append(")");
            stringBuilder.append("\tand p1.START_DATE between ");
            stringBuilder.append(dbHandler.getSqlDate(date));
            stringBuilder.append(" and ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
            stringBuilder.append(" and p1.PROCESS_ELEMENT_PARENT_ID is NULL");
            stringBuilder.append(" and p1.FILE_ID is NOT NULL");
            stringBuilder.append(" group by p1.FILE_ID");
            Util_Logger.debug(logger, stringBuilder.toString());
            List<congestionRec> list2 = DbManager.selectObjects(connection, stringBuilder.toString(), resultSet -> {
                congestionRec congestionRec2 = new congestionRec();
                congestionRec2.FileID = resultSet.getString("FILE_ID");
                congestionRec2.TotalCount = resultSet.getInt("TOTAL_FILEID_COUNT");
                return congestionRec2;
            });
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                congestionRec congestionRec2 = (congestionRec)iterator.next();
                treeMap.put(congestionRec2.FileID, congestionRec2);
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("select");
            stringBuilder.append(" p1.FILE_ID");
            stringBuilder.append(" ,count(1) as CONGESTED_FILEID_COUNT");
            stringBuilder.append(",avg(");
            stringBuilder.append(dbHandler.getSqlDateDiffInSecs("p1.EVENT_RECEIVED_DATE", "p1.START_DATE"));
            stringBuilder.append(") as AVG_PRIORITISATION_DELAY_SECS");
            stringBuilder.append(",max(");
            stringBuilder.append(dbHandler.getSqlDateDiffInSecs("p1.EVENT_RECEIVED_DATE", "p1.START_DATE"));
            stringBuilder.append(") as MAX_PRIORITISATION_DELAY_SECS");
            stringBuilder.append(" from PDR_MONITOR_PERFORMANCE p1");
            stringBuilder.append(" where p1.PDR_MONITOR_ID in (");
            string5 = "";
            for (pdrMonitorSource pdrMonitorSource2 : list) {
                stringBuilder.append(string5);
                stringBuilder.append(pdrMonitorSource2.pdr_monitor_id);
                string5 = ",";
            }
            stringBuilder.append(")");
            stringBuilder.append("\tand p1.START_DATE between ");
            stringBuilder.append(dbHandler.getSqlDate(date));
            stringBuilder.append(" and ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
            stringBuilder.append(" and p1.PROCESS_ELEMENT_PARENT_ID is NULL");
            stringBuilder.append(" and p1.FILE_ID is NOT NULL");
            stringBuilder.append(" and exists (");
            stringBuilder.append(" select 1 from PDR_MONITOR_PERFORMANCE p2");
            stringBuilder.append(" where p2.PDR_MONITOR_ID = p1.PDR_MONITOR_ID");
            stringBuilder.append(" and p2.THREAD_ID = p1.THREAD_ID");
            stringBuilder.append(" and p2.END_DATE between p1.EVENT_RECEIVED_DATE and p1.START_DATE");
            stringBuilder.append(" and p2.PROCESS_ELEMENT_PARENT_ID is NULL");
            stringBuilder.append(" and p2.FILE_ID is NOT NULL");
            stringBuilder.append(")");
            stringBuilder.append(" group by p1.FILE_ID");
            Util_Logger.debug(logger, stringBuilder.toString());
            List<congestionRec> list3 = DbManager.selectObjects(connection, stringBuilder.toString(), resultSet -> {
                String string = resultSet.getString("FILE_ID");
                congestionRec congestionRec2 = (congestionRec)treeMap.get(string);
                if (congestionRec2 != null) {
                    congestionRec2.CongestedCount = resultSet.getInt("CONGESTED_FILEID_COUNT");
                    congestionRec2.AvgPriortisationDelaysSecs = resultSet.getDouble("AVG_PRIORITISATION_DELAY_SECS");
                    congestionRec2.MaxPriortisationDelaysSecs = resultSet.getDouble("MAX_PRIORITISATION_DELAY_SECS");
                    congestionRec2.CongestedPercent = (double)congestionRec2.CongestedCount / (double)congestionRec2.TotalCount;
                }
                return congestionRec2;
            });
            string4 = JsonUtilities.toJson(treeMap.values());
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ, Path="${FileId}")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getFileIdCongestion(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n, @WebParam(source="AsAtDate", mandatory=true, validatorParam=WebParamValidationEnum.DATE) Date date, @WebParam(source="FileId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string4) throws Exception {
        String string5 = null;
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
            List<pdrMonitorSource> list = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
            Date date2 = Util.dateOffset(date, 1, 5);
            DbHandler dbHandler = DbManager.getDbHandler();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select p1.FILE_ID");
            stringBuilder.append(", p1.THREAD_ID");
            stringBuilder.append(", p2.FILE_ID as QUEUED_BEHIND");
            stringBuilder.append(", count(1) as QUEUED_BEHIND_FREQUENCY");
            stringBuilder.append(",avg(");
            stringBuilder.append(dbHandler.getSqlDateDiffInSecs("p1.EVENT_RECEIVED_DATE", "p1.START_DATE"));
            stringBuilder.append(") as AVG_PRIORITISATION_DELAY_SECS");
            stringBuilder.append(",max(");
            stringBuilder.append(dbHandler.getSqlDateDiffInSecs("p1.EVENT_RECEIVED_DATE", "p1.START_DATE"));
            stringBuilder.append(") as MAX_PRIORITISATION_DELAY_SECS");
            stringBuilder.append(" from PDR_MONITOR_PERFORMANCE p1, PDR_MONITOR_PERFORMANCE p2");
            stringBuilder.append(" where p1.PDR_MONITOR_ID in (");
            String string6 = "";
            for (pdrMonitorSource object22 : list) {
                stringBuilder.append(string6);
                stringBuilder.append(object22.pdr_monitor_id);
                string6 = ",";
            }
            stringBuilder.append(")");
            stringBuilder.append("\tand p1.START_DATE between ");
            stringBuilder.append(dbHandler.getSqlDate(date));
            stringBuilder.append(" and ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
            stringBuilder.append(" and P1.FILE_ID = ?");
            stringBuilder.append(" and P1.PROCESS_ELEMENT_PARENT_ID is NULL");
            stringBuilder.append("\tand p2.PDR_MONITOR_ID = p1.PDR_MONITOR_ID");
            stringBuilder.append("\tand p2.THREAD_ID = p1.THREAD_ID");
            stringBuilder.append("\tand p2.END_DATE between p1.EVENT_RECEIVED_DATE and p1.START_DATE");
            stringBuilder.append(" and P2.PROCESS_ELEMENT_PARENT_ID is NULL");
            stringBuilder.append(" and p2.FILE_ID is NOT NULL");
            stringBuilder.append(" group by p1.FILE_ID");
            stringBuilder.append(", p1.THREAD_ID");
            stringBuilder.append(", p2.FILE_ID");
            stringBuilder.append(" order by p1.FILE_ID");
            stringBuilder.append(", p1.THREAD_ID");
            stringBuilder.append(", p2.FILE_ID");
            Util_Logger.debug(logger, stringBuilder.toString());
            List<congestionRec> list2 = DbManager.selectObjects(connection, stringBuilder.toString(), preparedStatement -> preparedStatement.setString(1, string4), resultSet -> {
                congestionRec congestionRec2 = new congestionRec();
                congestionRec2.FileID = resultSet.getString("FILE_ID");
                congestionRec2.ThreadID = resultSet.getInt("THREAD_ID");
                congestionRec2.QueuedBehind = resultSet.getString("QUEUED_BEHIND");
                congestionRec2.QueuedBehindFrequency = resultSet.getInt("QUEUED_BEHIND_FREQUENCY");
                congestionRec2.AvgPriortisationDelaysSecs = resultSet.getDouble("AVG_PRIORITISATION_DELAY_SECS");
                congestionRec2.MaxPriortisationDelaysSecs = resultSet.getDouble("MAX_PRIORITISATION_DELAY_SECS");
                return congestionRec2;
            });
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Object object = (congestionRec)iterator.next();
                if (arrayList.contains(((congestionRec)object).FileID)) continue;
                arrayList.add(((congestionRec)object).FileID);
            }
            for (Object object : arrayList) {
                congestionRec congestionRec2;
                int n2 = 0;
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    congestionRec2 = (congestionRec)iterator2.next();
                    if (!congestionRec2.FileID.equalsIgnoreCase((String)object)) continue;
                    n2 += congestionRec2.QueuedBehindFrequency;
                }
                iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    congestionRec2 = (congestionRec)iterator2.next();
                    if (!congestionRec2.FileID.equalsIgnoreCase((String)object)) continue;
                    congestionRec2.CongestedPercent = (double)congestionRec2.QueuedBehindFrequency / (double)n2;
                }
            }
            string5 = JsonUtilities.toJson(list2);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ, Path="${FileId}/samples")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getFileIdCongestionSamples(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n, @WebParam(source="AsAtDate", mandatory=true, validatorParam=WebParamValidationEnum.DATE) Date date, @WebParam(source="FileId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string4, @WebParam(source="Samples", mandatory=false, defaultValue="10", validatorParam=WebParamValidationEnum.POSITIVE) int n2) throws Exception {
        String string5 = null;
        List<pdrPerformanceRec> list = null;
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        List<pdrMonitorSource> list2 = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
        Date date2 = Util.dateOffset(date, 1, 5);
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            DbHandler dbHandler = DbManager.getDbHandler();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("*");
            stringBuilder.append(" from PDR_MONITOR_PERFORMANCE p1");
            stringBuilder.append(" where p1.PDR_MONITOR_ID in (");
            String string6 = "";
            for (pdrMonitorSource object : list2) {
                stringBuilder.append(string6);
                stringBuilder.append(object.pdr_monitor_id);
                string6 = ",";
            }
            stringBuilder.append(")");
            stringBuilder.append(" and p1.FILE_ID = ?");
            stringBuilder.append(" and (p1.START_DATE between ");
            stringBuilder.append(dbHandler.getSqlDate(date));
            stringBuilder.append(" and ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
            stringBuilder.append(")");
            stringBuilder.append(" and p1.PROCESS_ELEMENT_PARENT_ID is NULL");
            stringBuilder.append(" and p1.FILE_ID is NOT NULL");
            stringBuilder.append(" and exists (");
            stringBuilder.append(" select 1 from PDR_MONITOR_PERFORMANCE p2");
            stringBuilder.append(" where p2.PDR_MONITOR_ID = p1.PDR_MONITOR_ID");
            stringBuilder.append(" and p2.THREAD_ID = p1.THREAD_ID");
            stringBuilder.append(" and p2.PROCESS_ELEMENT_PARENT_ID is NULL");
            stringBuilder.append(" and p2.FILE_ID is NOT NULL");
            stringBuilder.append(" and (p2.END_DATE between p1.EVENT_RECEIVED_DATE and p1.START_DATE)");
            stringBuilder.append(")");
            String string7 = dbHandler.getSqlRowLimited(stringBuilder.toString(), dbHandler.getSqlDateDiffInSecs("p1.EVENT_RECEIVED_DATE", "p1.START_DATE") + " desc", n2);
            Util_Logger.debug(logger, string7);
            list = DbManager.selectObjects(connection, pdrPerformanceRec.class, null, "PDR_MONITOR_PERFORMANCE", string7, preparedStatement -> preparedStatement.setString(1, string4));
            for (pdrPerformanceRec pdrPerformanceRec2 : list) {
                pdrPerformanceRec2.setStartDate(pdrPerformanceRec2.getStartDate());
            }
            string5 = JsonUtilities.toJson(list);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ, Path="detail")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getFilenameCongestionDetail(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n, @WebParam(source="AsAtDate", mandatory=true, validatorParam=WebParamValidationEnum.DATE) Date date, @WebParam(source="Filename", mandatory=true, validatorParam=WebParamValidationEnum.STR_FILENAME) String string4) throws Exception {
        String string5 = null;
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        List<pdrMonitorSource> list = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
        Date date2 = Util.dateOffset(date, 1, 5);
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            DbHandler dbHandler = DbManager.getDbHandler();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select p1.*");
            stringBuilder.append(" from");
            stringBuilder.append(" PDR_MONITOR_PERFORMANCE p1");
            stringBuilder.append(" where p1.PDR_MONITOR_ID in (");
            String string6 = "";
            for (pdrMonitorSource object2 : list) {
                stringBuilder.append(string6);
                stringBuilder.append(object2.pdr_monitor_id);
                string6 = ",";
            }
            stringBuilder.append(")");
            stringBuilder.append(" and p1.FILE_NAME = ?");
            stringBuilder.append("\tand p1.START_DATE between ");
            stringBuilder.append(dbHandler.getSqlDate(date));
            stringBuilder.append(" and ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
            stringBuilder.append(" and p1.PROCESS_ELEMENT_PARENT_ID is NULL");
            Util_Logger.debug(logger, stringBuilder.toString());
            List<pdrPerformanceRec> list2 = DbManager.selectObjects(connection, pdrPerformanceRec.class, null, "PDR_MONITOR_PERFORMANCE", stringBuilder.toString(), preparedStatement -> preparedStatement.setString(1, string4));
            if (list2.size() == 0) {
                throw new Exception("Unable to find performance data file filename [" + string4 + "]");
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("select p1.*");
            stringBuilder.append(" from");
            stringBuilder.append(" PDR_MONITOR_PERFORMANCE p1");
            stringBuilder.append(" where p1.PDR_MONITOR_ID = ?");
            stringBuilder.append(" and p1.THREAD_ID = ?");
            stringBuilder.append(" and ((p1.END_DATE BETWEEN ? and ?) or (p1.FILE_NAME = ?))");
            stringBuilder.append(" and p1.PROCESS_ELEMENT_PARENT_ID is NULL");
            stringBuilder.append(" and p1.FILE_ID is NOT NULL");
            stringBuilder.append(" order by p1.START_DATE");
            Util_Logger.debug(logger, stringBuilder.toString());
            List<pdrPerformanceRec> list3 = DbManager.selectObjects(connection, pdrPerformanceRec.class, null, "PDR_MONITOR_PERFORMANCE", stringBuilder.toString(), preparedStatement -> {
                preparedStatement.setInt(1, ((pdrPerformanceRec)list2.get(0)).getPdrMonitorId());
                preparedStatement.setString(2, ((pdrPerformanceRec)list2.get(0)).getThreadId());
                preparedStatement.setTimestamp(3, new Timestamp(((pdrPerformanceRec)list2.get(0)).getEventReceivedDate().getTime()));
                preparedStatement.setTimestamp(4, new Timestamp(((pdrPerformanceRec)list2.get(0)).getEndDate().getTime()));
                preparedStatement.setString(5, string4);
            });
            for (pdrPerformanceRec pdrPerformanceRec2 : list3) {
                pdrPerformanceRec2.setStartDate(pdrPerformanceRec2.getStartDate());
            }
            string5 = JsonUtilities.toJson(list3);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string5;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
    private class congestionRec {
        public int ThreadID;
        public String FileID;
        public int TotalCount;
        public int CongestedCount;
        public double CongestedPercent;
        public String QueuedBehind;
        public int QueuedBehindFrequency;
        public double AvgPriortisationDelaysSecs;
        public double MaxPriortisationDelaysSecs;

        private congestionRec() {
        }
    }
}

