/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Common.Monitor.pdrLoggerRec;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.Date;
import java.util.List;

@WebPath(value="/api/system/${system}/${application}/${instanceId}/logger")
@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="endDateTime is consumed")
public class WebAPIApplicationLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Date variables are cleaned and the rest is application configuration. Prepared statement uses bind variables. No significant SQL injection risk")
    public String getApplicationLogger(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n, @WebParam(source="startDate", validatorParam=WebParamValidationEnum.DATE) Date date, @WebParam(source="endDate", validatorParam=WebParamValidationEnum.DATE) Date date2) throws Exception {
        String string4 = null;
        if (date == null) {
            date = Util.dateTruncateTime(new Date());
        }
        date2 = date2 == null ? Util.dateOffset(date, 1, 5) : Util.dateOffset(date2, 1, 5);
        DbHandler dbHandler = DbManager.getDbHandler();
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        List<pdrMonitorSource> list = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select * from PDR_MONITOR_LOG_MESSAGES");
        stringBuilder.append(" where PDR_MONITOR_ID in (");
        String string5 = "";
        for (pdrMonitorSource object2 : list) {
            stringBuilder.append(string5);
            stringBuilder.append(object2.pdr_monitor_id);
            string5 = ",";
        }
        stringBuilder.append(") and EVENT_DATE BETWEEN ");
        stringBuilder.append(dbHandler.getSqlDate(date));
        stringBuilder.append(" AND ");
        stringBuilder.append(dbHandler.getSqlDate(date2));
        stringBuilder.append(" order by EVENT_DATE DESC");
        Object object = null;
        try {
            object = DbManager.getDbConnection();
            List<pdrLoggerRec> list2 = DbManager.selectObjects((Connection)object, pdrLoggerRec.class, null, "PDR_MONITOR_LOG_MESSAGES", stringBuilder.toString());
            Monitor monitor = new Monitor();
            monitor.logs = list2;
            string4 = JsonUtilities.toJson(monitor);
        }
        finally {
            DbManager.freeDbConnection((Connection)object);
        }
        return string4;
    }

    @XStreamAlias(value="monitor")
    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class Monitor {
        public List<pdrLoggerRec> logs;

        private Monitor() {
        }
    }
}

