/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Monitor.API.LogsDaily;
import au.com.nemmco.Pdr.Monitor.API.logSummaryRec;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@WebPath(value="/api/system/${system}/${application}/${instanceId}/logger_summary")
public class WebAPIApplicationLoggerSummary {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Date variables are cleaned and the rest is application configuration. Prepared statement uses bind variables. No significant SQL injection risk")
    public String getApplicationLoggerSummary(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n, @WebParam(source="startDate", validatorParam=WebParamValidationEnum.DATE) Date date, @WebParam(source="endDate", validatorParam=WebParamValidationEnum.DATE) Date date2, @WebParam(source="reportingInterval", defaultValue="1440", validatorParam=WebParamValidationEnum.POSITIVE) int n2, @WebParam(source="recentLastMins", defaultValue="60", validatorParam=WebParamValidationEnum.POSITIVE) int n3) throws Exception {
        String string4 = null;
        Date date3 = Util.dateTruncateTime(new Date());
        if (date == null) {
            date = Util.dateOffset(date3, -4, 5);
        }
        date2 = date2 != null ? Util.dateOffset(date2, 1, 5) : Util.dateOffset(date3, 1, 5);
        Date date4 = Util.dateOffset(new Date(), -n3, 12);
        DbHandler dbHandler = DbManager.getDbHandler();
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        List<pdrMonitorSource> list = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        stringBuilder.append(dbHandler.getSqlDateRoundUp("EVENT_DATE", n2));
        stringBuilder.append(" AS SUMMARY_DATE,LOG_LEVEL,COUNT(1) as LOG_COUNT,MAX(EVENT_DATE) as LOG_MAX_DATE");
        stringBuilder.append(" from PDR_MONITOR_LOG_MESSAGES");
        stringBuilder.append(" where PDR_MONITOR_ID in (");
        String string5 = "";
        for (pdrMonitorSource object3 : list) {
            stringBuilder.append(string5);
            stringBuilder.append(object3.pdr_monitor_id);
            string5 = ",";
        }
        stringBuilder.append(") and EVENT_DATE > ");
        stringBuilder.append(dbHandler.getSqlDate(date));
        stringBuilder.append(" AND EVENT_DATE <= ");
        stringBuilder.append(dbHandler.getSqlDate(date2));
        stringBuilder.append(" GROUP BY ");
        stringBuilder.append(dbHandler.getSqlDateRoundUp("EVENT_DATE", n2));
        stringBuilder.append(" ,LOG_LEVEL");
        Object object = null;
        try {
            Object object22;
            ArrayList arrayList;
            object = DbManager.getDbConnection();
            List<logSummaryRec> list2 = DbManager.selectObjects((Connection)object, stringBuilder.toString(), resultSet -> {
                logSummaryRec logSummaryRec2 = new logSummaryRec();
                logSummaryRec2.SummaryDate = DbManager.readDate(resultSet, "SUMMARY_DATE");
                logSummaryRec2.LogLevel = resultSet.getString("LOG_LEVEL");
                logSummaryRec2.LogCount = resultSet.getInt("LOG_COUNT");
                logSummaryRec2.LogMaxDate = DbManager.readDate(resultSet, "LOG_MAX_DATE");
                return logSummaryRec2;
            });
            HashMap<Date, Object> hashMap = new HashMap<Date, Object>();
            Date date5 = Util.dateOffset(date, n2, 12);
            while (date5.compareTo(date2) <= 0) {
                arrayList = new LogsDaily();
                ((LogsDaily)((Object)arrayList)).SummaryDate = date5;
                hashMap.put(((LogsDaily)((Object)arrayList)).SummaryDate, arrayList);
                date5 = Util.dateOffset(date5, n2, 12);
            }
            for (Object object22 : list2) {
                Object object3 = (LogsDaily)hashMap.get(((logSummaryRec)object22).SummaryDate);
                if (object3 == null) {
                    object3 = new LogsDaily();
                    ((LogsDaily)object3).SummaryDate = ((logSummaryRec)object22).SummaryDate;
                    hashMap.put(((LogsDaily)object3).SummaryDate, object3);
                }
                if (((logSummaryRec)object22).LogLevel.equalsIgnoreCase("ERROR")) {
                    ((LogsDaily)object3).ErrorCount += ((logSummaryRec)object22).LogCount;
                    if (((logSummaryRec)object22).LogMaxDate == null || !((logSummaryRec)object22).LogMaxDate.after(date4)) continue;
                    ++((LogsDaily)object3).ErrorIsRecent;
                    continue;
                }
                if (((logSummaryRec)object22).LogLevel.equalsIgnoreCase("WARNING")) {
                    ((LogsDaily)object3).WarningCount += ((logSummaryRec)object22).LogCount;
                    if (((logSummaryRec)object22).LogMaxDate == null || !((logSummaryRec)object22).LogMaxDate.after(date4)) continue;
                    ++((LogsDaily)object3).WarningIsRecent;
                    continue;
                }
                throw new Exception("Unknown log record status " + ((logSummaryRec)object22).LogLevel + " detected");
            }
            arrayList = new ArrayList(hashMap.values());
            arrayList.sort((logsDaily, logsDaily2) -> logsDaily.SummaryDate.compareTo(logsDaily2.SummaryDate));
            object22 = new StringBuilder();
            ((StringBuilder)object22).append("Date,WARNING,ERROR,WARNING_IS_RECENT,ERROR_IS_RECENT");
            ((StringBuilder)object22).append("\r\n");
            for (LogsDaily logsDaily3 : arrayList) {
                if (n2 == 1440) {
                    ((StringBuilder)object22).append(Util.dateToStr(Util.dateOffset(logsDaily3.SummaryDate, -1, 5), "yyyy-MM-dd HH:mm:ss"));
                } else {
                    ((StringBuilder)object22).append(Util.dateToStr(logsDaily3.SummaryDate, "yyyy-MM-dd HH:mm:ss"));
                }
                ((StringBuilder)object22).append(",");
                ((StringBuilder)object22).append(logsDaily3.WarningCount);
                ((StringBuilder)object22).append(",");
                ((StringBuilder)object22).append(logsDaily3.ErrorCount);
                ((StringBuilder)object22).append(",");
                ((StringBuilder)object22).append(logsDaily3.WarningIsRecent);
                ((StringBuilder)object22).append(",");
                ((StringBuilder)object22).append(logsDaily3.ErrorIsRecent);
                ((StringBuilder)object22).append("\r\n");
            }
            string4 = ((StringBuilder)object22).toString();
        }
        finally {
            DbManager.freeDbConnection((Connection)object);
        }
        return string4;
    }
}

