/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebAPIBaseClass;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperApplication;
import au.com.nemmco.Pdr.Monitor.API.getPerfDataAggregate;
import au.com.nemmco.Pdr.Monitor.API.getPerfDataRaw;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@WebPath(value="/api/system/${system}/${application}/${instanceId}/performance")
public class WebAPIApplicationPerformance
extends WebAPIBaseClass {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="apc object properties are consumed")
    public String getApplicationPerformance(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n) throws Exception {
        String string4 = null;
        PerformanceHelperApplication performanceHelperApplication = new PerformanceHelperApplication(this);
        List<pdrPerformanceRec> list = null;
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        List<pdrMonitorSource> list2 = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
        Connection connection = null;
        try {
            Object object;
            Object object2;
            connection = DbManager.getDbConnection();
            if (performanceHelperApplication.aggregatedData) {
                object2 = new getPerfDataAggregate();
                list = ((getPerfDataAggregate)object2).loadData(connection, list2, performanceHelperApplication.startDateTime, performanceHelperApplication.endDateTime, performanceHelperApplication.reportingInterval, performanceHelperApplication.fileIDList, performanceHelperApplication.dataSource);
            } else {
                object2 = new getPerfDataRaw();
                list = ((getPerfDataRaw)object2).loadData(connection, list2, performanceHelperApplication.startDateTime, performanceHelperApplication.endDateTime, performanceHelperApplication.fileIDList, performanceHelperApplication.filename, performanceHelperApplication.jobType, performanceHelperApplication.dataSource);
            }
            object2 = new ArrayList();
            HashMap<Date, Object> hashMap = new HashMap<Date, Object>();
            Date date = performanceHelperApplication.startDateTime;
            while (date.before(performanceHelperApplication.endDateTime)) {
                object = new perfSummaryRec();
                ((perfSummaryRec)object).StartDateTime = date;
                ((perfSummaryRec)object).EndDateTime = date = Util.dateOffset(date, performanceHelperApplication.reportingInterval, 12);
                hashMap.put(((perfSummaryRec)object).StartDateTime, object);
                object2.add(((perfSummaryRec)object).StartDateTime);
            }
            for (pdrPerformanceRec pdrPerformanceRec2 : list) {
                if (pdrPerformanceRec2.getStartDate() == null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(pdrPerformanceRec2.getEndDate());
                    calendar.add(12, -performanceHelperApplication.reportingInterval);
                    pdrPerformanceRec2.setStartDate(calendar.getTime());
                } else if (pdrPerformanceRec2.getEndDate().equals(pdrPerformanceRec2.getStartDate())) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(pdrPerformanceRec2.getEndDate());
                    calendar.add(14, 500);
                    pdrPerformanceRec2.setEndDate(calendar.getTime());
                }
                long l = pdrPerformanceRec2.getEndDate().getTime() - pdrPerformanceRec2.getStartDate().getTime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(TimeZone.getDefault());
                calendar.setTimeInMillis(Math.max(pdrPerformanceRec2.getStartDate().getTime(), performanceHelperApplication.startDateTime.getTime()));
                int n2 = calendar.get(11) * 60 + calendar.get(12);
                int n3 = n2 % performanceHelperApplication.reportingInterval;
                if (n3 != 0) {
                    calendar.add(12, -n3);
                }
                calendar.set(13, 0);
                calendar.set(14, 0);
                while (calendar.getTime().before(pdrPerformanceRec2.getEndDate())) {
                    perfSummaryRec perfSummaryRec4 = (perfSummaryRec)hashMap.get(calendar.getTime());
                    long l2 = Math.max(perfSummaryRec4.StartDateTime.getTime(), pdrPerformanceRec2.getStartDate().getTime());
                    long l3 = Math.min(perfSummaryRec4.EndDateTime.getTime(), pdrPerformanceRec2.getEndDate().getTime());
                    long l4 = l3 - l2;
                    long l5 = Math.round((double)pdrPerformanceRec2.getJobSize() * (double)l4 / (double)l);
                    perfSeriesRec perfSeriesRec2 = perfSummaryRec4.SeriesData.get(pdrPerformanceRec2.getJobType().toUpperCase());
                    if (perfSeriesRec2 == null) {
                        perfSeriesRec2 = new perfSeriesRec();
                        perfSummaryRec4.SeriesData.put(pdrPerformanceRec2.getJobType().toUpperCase(), perfSeriesRec2);
                    }
                    perfSeriesRec2.PeakJobSize = Math.max(perfSeriesRec2.PeakJobSize, l5);
                    perfSeriesRec2.NoActiveJobs += pdrPerformanceRec2.getNoJobs();
                    perfSeriesRec2.TotalJobSize += l5;
                    perfSeriesRec2.AccumulatedDuration += l4;
                    perfSeriesRec2.TimeWeightedJobSummation += l5 * l4;
                    calendar.add(12, performanceHelperApplication.reportingInterval);
                }
            }
            object = new perfSummaryReport();
            ((perfSummaryReport)object).StartDateTime = performanceHelperApplication.startDateTime;
            ((perfSummaryReport)object).EndDateTime = performanceHelperApplication.endDateTime;
            ((perfSummaryReport)object).ReportingInterval = performanceHelperApplication.reportingInterval;
            ((perfSummaryReport)object).PerformanceData = new ArrayList(hashMap.values());
            Collections.sort(((perfSummaryReport)object).PerformanceData, (perfSummaryRec2, perfSummaryRec3) -> perfSummaryRec2.EndDateTime.compareTo(perfSummaryRec3.EndDateTime));
            string4 = JsonUtilities.toJson(object);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string4;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="class cannot be static")
    private class perfSummaryRec {
        public Date StartDateTime;
        public Date EndDateTime;
        public Map<String, perfSeriesRec> SeriesData = new HashMap<String, perfSeriesRec>();

        private perfSummaryRec() {
        }
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
    private class perfSeriesRec {
        public String SeriesName;
        public int NoActiveJobs;
        public long PeakJobSize;
        public long AverageJobSize;
        public long AccumulatedDuration;
        public long TimeWeightedJobSummation;
        public long TotalJobSize;

        private perfSeriesRec() {
        }
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    private class perfSummaryReport {
        public Date StartDateTime;
        public Date EndDateTime;
        public int ReportingInterval;
        public List<perfSummaryRec> PerformanceData = new ArrayList<perfSummaryRec>();

        private perfSummaryReport() {
        }
    }
}

