/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebParamValidatorTypeJSON;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Monitor.Collectors.pdrMonitorCollector;
import au.com.nemmco.Pdr.Monitor.Collectors.pdrMonitorCollectorManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import java.util.ArrayList;

@WebPath(value="/api/sources")
public class WebAPISources {
    @WebGET(Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getSources(@WebParam(source="filter", mandatory=false, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string) throws Exception {
        String string2 = null;
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        ArrayList<pdrMonitorSource> arrayList = new ArrayList<pdrMonitorSource>(pdrMonitorConfigManager2.getSources());
        ArrayList<pdrMonitorSource> arrayList2 = new ArrayList<pdrMonitorSource>();
        for (pdrMonitorSource object : arrayList) {
            if (Util.isBlank(string)) {
                arrayList2.add(object);
                continue;
            }
            if (string.equalsIgnoreCase("All")) {
                arrayList2.add(object);
                continue;
            }
            if (string.equalsIgnoreCase("Active")) {
                if (!Util.intToBoolean(object.IsActive)) continue;
                arrayList2.add(object);
                continue;
            }
            throw new Exception("Invalid filter for sources [" + string + "]");
        }
        pdrMonitorCollectorManager pdrMonitorCollectorManager2 = pdrMonitorCollectorManager.getInstance();
        for (pdrMonitorCollector pdrMonitorCollector2 : pdrMonitorCollectorManager2.getHandlers()) {
            for (pdrMonitorSource pdrMonitorSource2 : arrayList2) {
                if (pdrMonitorCollector2.getId() != pdrMonitorSource2.pdr_monitor_id.intValue()) continue;
                pdrMonitorSource2.IsRunning = pdrMonitorCollector2.getLastRunningStatus();
            }
        }
        string2 = JsonUtilities.listToJson(arrayList2);
        return string2;
    }

    @WebPOST(AdminAccessOnly=true, Action=AuthorisationActionEnum.WRITE)
    @WebContent(value=WebContent.MediaType.TEXT_PLAIN)
    public String createSource(@WebParam(source="_body", mandatory=true, validator=WebParamValidatorTypeJSON.class) pdrMonitorSource pdrMonitorSource2) throws Exception {
        String string = null;
        try {
            pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
            pdrMonitorConfigManager2.saveSource(pdrMonitorSource2);
            string = "Successfully saved source [" + pdrMonitorSource2.Hostname + ":" + pdrMonitorSource2.Port + ", app=" + pdrMonitorSource2.App_Name + "]";
        }
        catch (Exception exception) {
            string = "Failed to save source: " + exception.getMessage();
        }
        return string;
    }

    @WebPOST(AdminAccessOnly=true, Action=AuthorisationActionEnum.WRITE, Path="${source}/hmackey")
    @WebContent(value=WebContent.MediaType.TEXT_PLAIN)
    public String updateHMACKey(@WebParam(source="source", mandatory=true, validatorParam=WebParamValidationEnum.POSITIVE) int n) {
        Object object = null;
        try {
            pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
            object = pdrMonitorConfigManager2.cycleHMACKey(n);
        }
        catch (Exception exception) {
            object = "Failed to cycle HMAC key for source [" + n + "]: " + exception.getMessage();
        }
        return object;
    }
}

