/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthenticationManager;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebAPIBaseClass;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/dashboard")
public class WebAPIUserDashboard
extends WebAPIBaseClass {
    private static Logger logger = LoggerFactory.getLogger(WebAPIUserDashboard.class);
    private final String sourceTable = "PDR_MONITOR_USERS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getDashboardLayout() throws Exception {
        String string = null;
        Connection connection = null;
        try {
            AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
            if (!authenticationManager.isEnabled()) {
                throw new Exception("Authentication Manager is not configured");
            }
            String string2 = authenticationManager.getdUserId(this.getSessionKey());
            String string3 = "select DASHBOARD_LAYOUT from PDR_MONITOR_USERS where USER_ID = ? and DASHBOARD_LAYOUT is not NULL";
            connection = DbManager.getDbConnection();
            List<String> list = DbManager.selectObjects(connection, string3, preparedStatement -> preparedStatement.setString(1, string2), resultSet -> new String(resultSet.getString("DASHBOARD_LAYOUT")));
            if (list != null && list.size() > 0) {
                string = list.get(0);
            }
        }
        catch (Throwable throwable) {
            DbManager.freeDbConnection(connection);
            throw throwable;
        }
        DbManager.freeDbConnection(connection);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebPOST(Action=AuthorisationActionEnum.WRITE)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String updateDashboardLayout(@WebParam(source="_body", mandatory=true, validatorParam=WebParamValidationEnum.PASSTHROUGH) String string) throws Exception {
        Object object = null;
        Connection connection = null;
        try {
            AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
            if (!authenticationManager.isEnabled()) {
                throw new Exception("Authentication Manager is not configured");
            }
            String string2 = authenticationManager.getdUserId(this.getSessionKey());
            String string3 = "update PDR_MONITOR_USERS set DASHBOARD_LAYOUT = ? where USER_ID = ?";
            connection = DbManager.getDbConnection();
            try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.execute();
            }
            connection.commit();
            Util_Logger.info(logger, "Updated dashboard layout for user [" + string2 + "]");
            object = "Successfully saved dashboard";
        }
        catch (Exception exception) {
            try {
                Util_Logger.warning(logger, "Failed to save dashboard: " + exception.getMessage(), exception);
                object = "Failed to save dashboard: " + exception.getMessage();
            }
            catch (Throwable throwable) {
                DbManager.freeDbConnection(connection);
                throw throwable;
            }
            DbManager.freeDbConnection(connection);
        }
        DbManager.freeDbConnection(connection);
        return object;
    }
}

