/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbQueryResultsReader;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperDataInterchange;
import au.com.nemmco.Pdr.Monitor.API.dataInterchangePerformanceRec;
import au.com.nemmco.Pdr.Monitor.API.getDIPerfBase;
import au.com.nemmco.Pdr.Monitor.API.getDIPerfDataRaw;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class getDISLADataRaw
extends getDIPerfBase
implements DbQueryResultsReader {
    private static Logger logger = LoggerFactory.getLogger(getDIPerfDataRaw.class);

    getDISLADataRaw() {
    }

    private Date readDate(ResultSet resultSet, String string) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(string);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    private Double dateDiff(Date date, Date date2) {
        if (date == null) {
            return null;
        }
        if (date2 == null) {
            return null;
        }
        return (double)(date2.getTime() - date.getTime()) / 1000.0;
    }

    private boolean matchingFileId(dataInterchangePerformanceRec dataInterchangePerformanceRec2, dataInterchangePerformanceRec dataInterchangePerformanceRec3) {
        if (dataInterchangePerformanceRec2 == null) {
            return false;
        }
        if (dataInterchangePerformanceRec3 == null) {
            return false;
        }
        if (dataInterchangePerformanceRec2.getFileId().equalsIgnoreCase(dataInterchangePerformanceRec3.getFileId() + "_LEGACY")) {
            return true;
        }
        return dataInterchangePerformanceRec3.getFileId().equalsIgnoreCase(dataInterchangePerformanceRec2.getFileId() + "_LEGACY");
    }

    public dataInterchangePerformanceRec loadFromRset(ResultSet resultSet) throws SQLException {
        dataInterchangePerformanceRec dataInterchangePerformanceRec2 = new dataInterchangePerformanceRec();
        dataInterchangePerformanceRec2.setDataSource(resultSet.getString("DATA_SOURCE"));
        dataInterchangePerformanceRec2.setFileId(resultSet.getString("FILE_ID"));
        dataInterchangePerformanceRec2.setNoRecords(1);
        dataInterchangePerformanceRec2.setFilename(resultSet.getString("FILE_NAME"));
        dataInterchangePerformanceRec2.setFileExtension(resultSet.getString("FILE_EXTENSION"));
        dataInterchangePerformanceRec2.setIntervalStartDate(this.readDate(resultSet, "INTERVAL_START_DATE"));
        dataInterchangePerformanceRec2.setIntervalEndDate(this.readDate(resultSet, "INTERVAL_END_DATE"));
        Date date = this.readDate(resultSet, "INTERVAL_START_DATE");
        Date date2 = this.readDate(resultSet, "AEMO_CREATE_DATE");
        Date date3 = this.readDate(resultSet, "AEMO_DISTRIBUTE_DATE");
        Date date4 = this.readDate(resultSet, "BATCHER_START_DATE");
        Date date5 = this.readDate(resultSet, "BATCHER_END_DATE");
        Date date6 = this.readDate(resultSet, "LOADER_START_DATE");
        Date date7 = this.readDate(resultSet, "LOADER_END_DATE");
        dataInterchangePerformanceRec2.setAemoCreateSeconds(this.dateDiff(date, date2));
        dataInterchangePerformanceRec2.setAemoDistributeSeconds(this.dateDiff(date2, date3));
        dataInterchangePerformanceRec2.setBatcherStartSeconds(this.dateDiff(date3, date4));
        dataInterchangePerformanceRec2.setBatcherEndSeconds(this.dateDiff(date4, date5));
        dataInterchangePerformanceRec2.setLoaderStartSeconds(this.dateDiff(date5, date6));
        dataInterchangePerformanceRec2.setLoaderEndSeconds(this.dateDiff(date6, date7));
        dataInterchangePerformanceRec2.setEnd2EndSeconds(this.dateDiff(date, date7));
        dataInterchangePerformanceRec2.setEnd2EndSLA(resultSet.getDouble("END_TO_END_SLA"));
        return dataInterchangePerformanceRec2;
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="All parameters are either itnernal configuration or cleansed by a validation layer. Called by trusted code and no material SQL injection risk")
    public List<dataInterchangePerformanceRec> loadData(Connection connection, List<pdrMonitorSource> list, List<pdrMonitorSource> list2, Date date, Date date2, List<String> list3, String string, double d) throws Exception {
        Object object2;
        DbHandler dbHandler = DbManager.getDbHandler();
        if (list3.size() == 1) {
            object2 = list3.get(0);
            list3.add((String)object2 + "_LEGACY");
        }
        object2 = "( select FILE_ID, INTERVAL_ITEM_IN_FILENAME, BUSINESS_CYCLE_MINS, END_TO_END_SLA from PDR_MONITOR_PERFORMANCE_CONFIG  UNION  select " + dbHandler.concatStr("FILE_ID", "'_LEGACY'") + " as FILE_ID, INTERVAL_ITEM_IN_FILENAME, BUSINESS_CYCLE_MINS, END_TO_END_SLA from PDR_MONITOR_PERFORMANCE_CONFIG )";
        String string2 = dbHandler.getSqlDateAdd("l.INTERVAL_END_DATE", "-p.BUSINESS_CYCLE_MINS", 12);
        String string3 = dbHandler.getSqlDateDiffInSecs(string2, "l.END_DATE");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" select");
        stringBuilder.append(" l.DATA_SOURCE");
        stringBuilder.append(" ,l.FILE_ID");
        stringBuilder.append(" ,l.FILE_NAME");
        stringBuilder.append(" ,l.FILE_EXTENSION");
        stringBuilder.append(" ,l.INTERVAL_END_DATE");
        stringBuilder.append(" ," + string2 + " as INTERVAL_START_DATE");
        stringBuilder.append(" ,l.CONTENT_CREATION_DATE as AEMO_CREATE_DATE");
        stringBuilder.append(" ,b.CONTENT_CREATION_DATE as AEMO_DISTRIBUTE_DATE");
        stringBuilder.append(" ,b.START_DATE as BATCHER_START_DATE");
        stringBuilder.append(" ,b.END_DATE as BATCHER_END_DATE");
        stringBuilder.append(" ,l.START_DATE as LOADER_START_DATE");
        stringBuilder.append(" ,l.END_DATE as LOADER_END_DATE");
        stringBuilder.append(" ," + string3 + " as END_TO_END_SECS");
        stringBuilder.append(" ,p.END_TO_END_SLA");
        stringBuilder.append(" from");
        stringBuilder.append(" PDR_MONITOR_PERFORMANCE l");
        stringBuilder.append(" ,PDR_MONITOR_PERFORMANCE b");
        stringBuilder.append(" ," + (String)object2 + " p");
        stringBuilder.append(" where");
        stringBuilder.append(" l.PDR_MONITOR_ID in (");
        String string4 = "";
        for (pdrMonitorSource object3 : list2) {
            stringBuilder.append(string4);
            stringBuilder.append(object3.pdr_monitor_id);
            string4 = ",";
        }
        stringBuilder.append(")");
        stringBuilder.append(this.getLoaderPredicate(date, date2, true, "l", dbHandler));
        stringBuilder.append(PerformanceHelperDataInterchange.buildSQLPredicate("l.FILE_ID", list3));
        stringBuilder.append(PerformanceHelperDataInterchange.buildSQLPredicate("l.FILE_NAME", string));
        stringBuilder.append(" and l.CONFIDENTIALITY = 'PUBLIC'");
        stringBuilder.append(" and b.PDR_MONITOR_ID in (");
        string4 = "";
        for (pdrMonitorSource pdrMonitorSource2 : list) {
            stringBuilder.append(string4);
            stringBuilder.append(pdrMonitorSource2.pdr_monitor_id);
            string4 = ",";
        }
        stringBuilder.append(")");
        stringBuilder.append(" and b.FILE_NAME = l.FILE_NAME");
        stringBuilder.append(" and l.START_DATE = (select MIN(START_DATE) from PDR_MONITOR_PERFORMANCE where PDR_MONITOR_PERFORMANCE.PDR_MONITOR_ID=l.PDR_MONITOR_ID" + this.getLoaderPredicate(date, date2, true, "PDR_MONITOR_PERFORMANCE", dbHandler) + " and PDR_MONITOR_PERFORMANCE.FILE_NAME=l.FILE_NAME)");
        stringBuilder.append(" and b.START_DATE = (select MIN(START_DATE) from PDR_MONITOR_PERFORMANCE where PDR_MONITOR_PERFORMANCE.PDR_MONITOR_ID=b.PDR_MONITOR_ID and PDR_MONITOR_PERFORMANCE.FILE_NAME=b.FILE_NAME)");
        stringBuilder.append(" and p.FILE_ID = l.FILE_ID");
        stringBuilder.append(" and (" + string3 + " > (" + d + "*p.END_TO_END_SLA)) ");
        stringBuilder.append(" order by");
        stringBuilder.append(" l.INTERVAL_END_DATE, l.END_DATE");
        Util_Logger.debug(logger, stringBuilder.toString());
        List<dataInterchangePerformanceRec> list4 = DbManager.selectObjects(connection, stringBuilder.toString(), this::loadFromRset);
        ArrayList<dataInterchangePerformanceRec> arrayList = new ArrayList<dataInterchangePerformanceRec>();
        dataInterchangePerformanceRec dataInterchangePerformanceRec2 = null;
        Iterator iterator = list4.iterator();
        while (iterator.hasNext()) {
            dataInterchangePerformanceRec dataInterchangePerformanceRec3 = (dataInterchangePerformanceRec)iterator.next();
            if (dataInterchangePerformanceRec2 == null) {
                arrayList.add(dataInterchangePerformanceRec3);
            } else if (this.matchingFileId(dataInterchangePerformanceRec2, dataInterchangePerformanceRec3)) {
                if (dataInterchangePerformanceRec2.getIntervalEndDate().before(dataInterchangePerformanceRec3.getIntervalEndDate())) {
                    arrayList.add(dataInterchangePerformanceRec3);
                }
            } else {
                arrayList.add(dataInterchangePerformanceRec3);
            }
            dataInterchangePerformanceRec2 = dataInterchangePerformanceRec3;
        }
        return arrayList;
    }
}

