/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbQueryResultsReader;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperApplication;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class getPerfDataAggregate
implements DbQueryResultsReader {
    private static Logger logger = LoggerFactory.getLogger(getPerfDataAggregate.class);

    getPerfDataAggregate() {
    }

    public pdrPerformanceRec loadFromRset(ResultSet resultSet) throws SQLException {
        pdrPerformanceRec pdrPerformanceRec2 = new pdrPerformanceRec();
        pdrPerformanceRec2.setEndDate(new Date(resultSet.getTimestamp("END_DATE").getTime()));
        pdrPerformanceRec2.setFileId(resultSet.getString("FILE_ID"));
        pdrPerformanceRec2.setJobType(resultSet.getString("JOB_TYPE"));
        pdrPerformanceRec2.setJobSize(resultSet.getLong("JOB_SIZE"));
        pdrPerformanceRec2.setNoJobs(resultSet.getInt("NO_JOBS"));
        return pdrPerformanceRec2;
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="All parameters are either itnernal configuration or cleansed by a validation layer. Called by trusted code and no material SQL injection risk")
    public List<pdrPerformanceRec> loadData(Connection connection, List<pdrMonitorSource> list, Date date, Date date2, int n, List<String> list2, String string) throws Exception {
        DbHandler dbHandler = DbManager.getDbHandler();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        stringBuilder.append(dbHandler.getSqlDateRoundUp("END_DATE", n));
        stringBuilder.append(" as END_DATE ");
        stringBuilder.append(" ,FILE_ID,JOB_TYPE ");
        stringBuilder.append(" ,SUM(JOB_SIZE) as JOB_SIZE ");
        stringBuilder.append(" ,COUNT(1) as NO_JOBS ");
        stringBuilder.append(" from PDR_MONITOR_PERFORMANCE");
        stringBuilder.append(" where PDR_MONITOR_ID in (");
        String string2 = "";
        for (pdrMonitorSource pdrMonitorSource2 : list) {
            stringBuilder.append(string2);
            stringBuilder.append(pdrMonitorSource2.pdr_monitor_id);
            string2 = ",";
        }
        stringBuilder.append(")");
        stringBuilder.append(" and (START_DATE between ");
        stringBuilder.append(dbHandler.getSqlDate(Util.dateOffset(date, -1, 5)));
        stringBuilder.append(" and ");
        stringBuilder.append(dbHandler.getSqlDate(date2));
        stringBuilder.append(")");
        stringBuilder.append(" and (END_DATE > ");
        stringBuilder.append(dbHandler.getSqlDate(date));
        stringBuilder.append(")");
        stringBuilder.append(PerformanceHelperApplication.buildSQLPredicate("DATA_SOURCE", string));
        stringBuilder.append(PerformanceHelperApplication.buildSQLPredicate("FILE_ID", list2));
        stringBuilder.append(" and PROCESS_ELEMENT_PARENT_ID is NULL");
        stringBuilder.append(" group by ");
        stringBuilder.append(dbHandler.getSqlDateRoundUp("END_DATE", n));
        stringBuilder.append(",FILE_ID,JOB_TYPE");
        stringBuilder.append(" order by ");
        stringBuilder.append(dbHandler.getSqlDateRoundUp("END_DATE", n));
        stringBuilder.append(",FILE_ID,JOB_TYPE");
        Util_Logger.debug(logger, stringBuilder.toString());
        return DbManager.selectObjects(connection, stringBuilder.toString(), this::loadFromRset);
    }
}

