/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbQueryResultsReader;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceJobSizeUnits;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperApplication;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class getPerfDataRaw
implements DbQueryResultsReader {
    private static Logger logger = LoggerFactory.getLogger(getPerfDataRaw.class);

    getPerfDataRaw() {
    }

    public pdrPerformanceRec loadFromRset(ResultSet resultSet) throws SQLException {
        pdrPerformanceRec pdrPerformanceRec2 = new pdrPerformanceRec();
        pdrPerformanceRec2.setPdrMonitorId(resultSet.getInt("PDR_MONITOR_ID"));
        pdrPerformanceRec2.setTransactionId(resultSet.getString("TRANSACTION_ID"));
        pdrPerformanceRec2.setStartDate(new Date(resultSet.getTimestamp("START_DATE").getTime()));
        pdrPerformanceRec2.setEndDate(new Date(resultSet.getTimestamp("END_DATE").getTime()));
        pdrPerformanceRec2.setContentCreationDate(new Date(resultSet.getTimestamp("CONTENT_CREATION_DATE").getTime()));
        pdrPerformanceRec2.setDataSource(resultSet.getString("DATA_SOURCE"));
        pdrPerformanceRec2.setFileId(resultSet.getString("FILE_ID"));
        pdrPerformanceRec2.setFilename(resultSet.getString("FILE_NAME"));
        pdrPerformanceRec2.setFileExtension(resultSet.getString("FILE_EXTENSION"));
        pdrPerformanceRec2.setJobType(resultSet.getString("JOB_TYPE"));
        pdrPerformanceRec2.setJobSize(resultSet.getLong("JOB_SIZE"));
        pdrPerformanceRec2.setJobSizeUnits(pdrPerformanceJobSizeUnits.valueOf(resultSet.getString("JOB_SIZE_UNITS")));
        pdrPerformanceRec2.setThreadId(resultSet.getString("THREAD_ID"));
        pdrPerformanceRec2.setNoJobs(1);
        return pdrPerformanceRec2;
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="All parameters are either itnernal configuration or cleansed by a validation layer. Called by trusted code and no material SQL injection risk")
    public List<pdrPerformanceRec> loadData(Connection connection, List<pdrMonitorSource> list, Date date, Date date2, List<String> list2, String string, String string2, String string3) throws Exception {
        DbHandler dbHandler = DbManager.getDbHandler();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select * from PDR_MONITOR_PERFORMANCE");
        stringBuilder.append(" where PDR_MONITOR_ID in (");
        String string4 = "";
        for (pdrMonitorSource pdrMonitorSource2 : list) {
            stringBuilder.append(string4);
            stringBuilder.append(pdrMonitorSource2.pdr_monitor_id);
            string4 = ",";
        }
        stringBuilder.append(")");
        if (date != null && date2 != null) {
            stringBuilder.append(" and (START_DATE between ");
            stringBuilder.append(dbHandler.getSqlDate(Util.dateOffset(date, -1, 5)));
            stringBuilder.append(" and ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
            stringBuilder.append(")");
        }
        if (date != null) {
            stringBuilder.append(" and (END_DATE > ");
            stringBuilder.append(dbHandler.getSqlDate(date));
            stringBuilder.append(")");
        }
        stringBuilder.append(PerformanceHelperApplication.buildSQLPredicate("FILE_ID", list2));
        stringBuilder.append(PerformanceHelperApplication.buildSQLPredicate("FILE_NAME", string));
        stringBuilder.append(PerformanceHelperApplication.buildSQLPredicate("JOB_TYPE", string2));
        stringBuilder.append(PerformanceHelperApplication.buildSQLPredicate("DATA_SOURCE", string3));
        stringBuilder.append(" and PROCESS_ELEMENT_PARENT_ID is NULL");
        stringBuilder.append(" order by START_DATE, END_DATE");
        Util_Logger.debug(logger, stringBuilder.toString());
        return DbManager.selectObjects(connection, stringBuilder.toString(), this::loadFromRset);
    }
}

