/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor;

import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Monitor.Config.ConfigWrapper;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSystem;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSystemGrants;
import au.com.nemmco.Pdr.Monitor.pdrMonitor;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPdrMonitorRegisterSystem {
    private static Logger logger = LoggerFactory.getLogger(AppPdrMonitorRegisterSystem.class);

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Options options = new Options();
        options.addRequiredOption("s", "system", true, "The system group to create");
        options.addOption("a", "active", true, "Whether the system group is set active (true) or inactive (false)");
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            object = new HelpFormatter();
            object.printHelp(AppPdrMonitorRegisterSystem.class.getSimpleName(), options);
            System.exit(1);
        }
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        object = (ConfigWrapper)applicationManager.init(AppPdrMonitorRegisterSystem.class.getSimpleName(), "1.3.1", AppPdrMonitorRegisterSystem.class, pdrMonitor.CONFIGURATION_FILE, ConfigWrapper.class, null, applicationManager.buildStartOptions().startDatabase().createClientCertificateStore());
        try {
            String string = commandLine.getOptionValue("system");
            String string2 = commandLine.getOptionValue("active", null);
            Boolean bl = null;
            if (!Util.isBlank(string2)) {
                bl = string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("y");
            }
            pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
            pdrMonitorConfigManager2.setConfig((ConfigWrapper)object, false);
            pdrMonitorConfigManager2.loadFromDatabase();
            boolean bl2 = false;
            pdrMonitorSystem pdrMonitorSystem2 = null;
            for (pdrMonitorSystem object2 : pdrMonitorConfigManager2.getSystems()) {
                if (!object2.System_Id.equalsIgnoreCase(string)) continue;
                pdrMonitorSystem2 = object2;
            }
            if (pdrMonitorSystem2 == null) {
                pdrMonitorSystem2 = new pdrMonitorSystem();
                pdrMonitorSystem2.System_Id = string;
                bl2 = true;
                Util_Logger.info(logger, "Registering new monitor system " + pdrMonitorSystem2.System_Id);
            }
            if (bl != null) {
                pdrMonitorSystem2.Is_Active = Util.booleanToInt(bl);
            }
            boolean bl3 = false;
            if (pdrMonitorSystem2.Grants != null) {
                for (pdrMonitorSystemGrants pdrMonitorSystemGrants2 : pdrMonitorSystem2.Grants) {
                    if (!pdrMonitorSystemGrants2.Role_Id.equalsIgnoreCase(object.Authentication.AdminRole)) continue;
                    bl3 = true;
                    pdrMonitorSystemGrants2.Can_Configure = Util.booleanToInt(true);
                    pdrMonitorSystemGrants2.Can_View = Util.booleanToInt(true);
                }
            }
            if (!bl3) {
                pdrMonitorSystemGrants pdrMonitorSystemGrants3 = new pdrMonitorSystemGrants();
                pdrMonitorSystemGrants3.System_Id = string;
                pdrMonitorSystemGrants3.Role_Id = object.Authentication.AdminRole;
                pdrMonitorSystemGrants3.Can_Configure = Util.booleanToInt(true);
                pdrMonitorSystemGrants3.Can_View = Util.booleanToInt(true);
                if (pdrMonitorSystem2.Grants == null) {
                    pdrMonitorSystem2.Grants = new ArrayList<pdrMonitorSystemGrants>();
                }
                pdrMonitorSystem2.Grants.add(pdrMonitorSystemGrants3);
            }
            pdrMonitorConfigManager2.saveSystem(pdrMonitorSystem2);
            if (bl2) {
                Util_Logger.info(logger, "Registered new monitor system " + pdrMonitorSystem2.System_Id);
            } else {
                Util_Logger.info(logger, "Updated existing monitor system " + pdrMonitorSystem2.System_Id);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error registering application to monitor: " + exception.getMessage(), exception);
            System.exit(1);
        }
        System.exit(0);
    }
}

