/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor;

import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.Authentication.KeyManager;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Certificate.CertificateUtilities;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebClientAuthHMAC;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.nemmco.Pdr.Monitor.Config.ConfigWrapper;
import au.com.nemmco.Pdr.Monitor.pdrMonitor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPdrMonitorSourceCycleKey {
    private static Logger logger = LoggerFactory.getLogger(AppPdrMonitorSourceCycleKey.class);

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Fields populated by JSON serialisations")
    public static void main(String[] stringArray) throws Exception {
        Object object;
        Options options = new Options();
        options.addRequiredOption("s", "source", true, "The source ID to cycle");
        options.addOption("b", "bits", true, "The number of bits for the key");
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            object = new HelpFormatter();
            object.printHelp(AppPdrMonitorSourceCycleKey.class.getSimpleName(), options);
            System.exit(1);
        }
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        object = (ConfigWrapper)applicationManager.init(AppPdrMonitorSourceCycleKey.class.getSimpleName(), "1.3.1", AppPdrMonitorSourceCycleKey.class, pdrMonitor.CONFIGURATION_FILE, ConfigWrapper.class, null, applicationManager.buildStartOptions());
        try {
            Object object2;
            int n = Integer.parseInt(commandLine.getOptionValue("source"));
            int n2 = Integer.parseInt(commandLine.getOptionValue("bits", "64"));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object.WebServer.getHttpProtocol() ? "http" : "https");
            stringBuilder.append("://localhost:");
            stringBuilder.append(object.WebServer.Port);
            stringBuilder.append("/api/sources/");
            stringBuilder.append(n);
            stringBuilder.append("/hmackey");
            String string = KeyManager.generateKey(n2);
            if (!object.WebServer.getHttpProtocol()) {
                object2 = CertificateManager.getInstance();
                ((CertificateUtilities)object2).setCertStoreConfig(object.WebServer.HTTPS);
            }
            object2 = new WebClient().setTimeoutConnectionSecs(10).setTimeoutTransferSecs(10).setUseDefaultSSLContext(false);
            ((WebClient)object2).setAuthProvider(new WebClientAuthHMAC().setAPIKey(KeyManager.getInstance().getHMACKey()));
            WebHttpResponse webHttpResponse = ((WebClient)object2).doPost(stringBuilder.toString(), null, WebContent.MediaType.TEXT_PLAIN, string);
            if (webHttpResponse.ReturnCode != 200) {
                throw new Exception(webHttpResponse.Body);
            }
            Util_Logger.info(logger, webHttpResponse.Body);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error cycling HMAC key: " + exception.getMessage(), exception);
            System.exit(1);
        }
        System.exit(0);
    }
}

