/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.Collectors;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Threading.threadMonitorCPU;
import au.com.aemo.Common.Threading.threadMonitorCheckInt;
import au.com.aemo.Common.Threading.threadMonitorStatusItem;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebClientAuthHMAC;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.aemo.Common.XML.XmlUtilities;
import au.com.nemmco.Pdr.Common.Monitor.pdrLoggerRec;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorDataSet;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorRec;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import au.com.nemmco.Pdr.Monitor.Collectors.pdrMonitorCollectorManager;
import au.com.nemmco.Pdr.Monitor.Config.ConfigWrapper;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorDataInterchangePerfSLA;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorServiceStatus;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSystem;
import com.thoughtworks.xstream.XStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.Socket;
import java.sql.Connection;
import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrMonitorCollector
implements Runnable,
threadMonitorCheckInt {
    private static Logger logger = LoggerFactory.getLogger(pdrMonitorCollector.class);
    private static final int PollCyclesToCatchupMode = 3;
    private ConfigWrapper itsGlobalConfig;
    private int itsConfigId;
    private volatile pdrMonitorSource itsSourceConfig;
    private pdrMonitorSystem itsSystemConfig;
    private volatile boolean itsIsRunning;
    private WebClient itsWebClient;
    private threadMonitorCPU itsCpuProcessStats;
    private long itsLoggingRowsProcessed;
    private long itsPerformanceRowsProcessed;
    private Boolean itsLastActiveStatus;
    private Date itsLastActiveStatusDate;
    private Boolean itsLastRunningStatus;
    private Date itsLastRunningStatusDate;
    private volatile boolean itsHasDatabaseConfig;

    public pdrMonitorCollector(ConfigWrapper configWrapper, int n) {
        this.itsGlobalConfig = configWrapper;
        this.itsConfigId = n;
        this.itsCpuProcessStats = new threadMonitorCPU(0L);
        this.itsHasDatabaseConfig = false;
        this.updateSourceConfig();
        this.itsWebClient = pdrMonitorConfigManager.getInstance().createWebClient();
        this.itsIsRunning = true;
    }

    public int getId() {
        return this.itsConfigId;
    }

    private synchronized void updateSourceConfig() {
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        pdrMonitorSource pdrMonitorSource2 = pdrMonitorConfigManager2.getSource(this.itsConfigId);
        if (pdrMonitorSource2 != null) {
            this.itsSourceConfig = pdrMonitorSource2;
            this.itsHasDatabaseConfig = true;
            pdrMonitorSystem pdrMonitorSystem2 = null;
            try {
                pdrMonitorSystem2 = pdrMonitorConfigManager2.getSystem(this.itsSourceConfig.System_Id);
                if (pdrMonitorSystem2 != null) {
                    this.itsSystemConfig = pdrMonitorSystem2;
                }
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Unable to refresh system configuration in collector: " + exception.getMessage(), exception);
            }
        } else {
            this.itsHasDatabaseConfig = false;
            Util_Logger.warning(logger, "Detected collector configuration has been removed from database, pausing collector");
        }
    }

    public String getName() {
        return "COLLECTOR_SOURCE_" + this.itsSourceConfig.pdr_monitor_id;
    }

    public boolean getIsRunning() {
        return this.itsIsRunning;
    }

    public void stop() {
        this.itsIsRunning = false;
    }

    public String getSystem() {
        return this.itsSourceConfig.System_Id;
    }

    public String getApplication() {
        return this.itsSourceConfig.App_Name;
    }

    public boolean getCollectorIsActive() {
        return this.itsIsRunning && this.itsHasDatabaseConfig;
    }

    protected boolean getSystemIsActive() {
        boolean bl = false;
        if (this.itsSystemConfig != null) {
            bl = Util.intToBoolean(this.itsSystemConfig.Is_Active);
        }
        return bl;
    }

    protected boolean getSourceIsEnabled() {
        boolean bl = this.getSystemIsActive();
        if (this.itsSourceConfig != null) {
            bl = bl && Util.intToBoolean(this.itsSourceConfig.IsActive);
        }
        return bl;
    }

    protected boolean getSourceIsRunning() {
        boolean bl = false;
        try (Socket socket = new Socket(this.itsSourceConfig.Hostname, this.itsSourceConfig.Port);){
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public Boolean getLastRunningStatus() {
        return this.itsLastRunningStatus;
    }

    protected Date getLastRunningStatusDate() {
        return this.itsLastRunningStatusDate;
    }

    public Boolean getLastActiveStatus() {
        return this.itsLastActiveStatus;
    }

    protected Date lastActiveStatusDate() {
        return this.itsLastActiveStatusDate;
    }

    protected boolean getIsAutoActive() {
        return Util.intToBoolean(this.itsSourceConfig.IsAutoActive);
    }

    private boolean getIsActive() {
        boolean bl = false;
        boolean bl2 = this.getSourceIsRunning();
        boolean bl3 = this.getSourceIsEnabled();
        boolean bl4 = bl3;
        if (bl4 && this.getIsAutoActive()) {
            bl4 = bl2;
        }
        boolean bl5 = false;
        if (this.itsLastActiveStatus == null) {
            bl5 = true;
        } else if (bl4 != this.itsLastActiveStatus) {
            bl5 = true;
            bl = true;
        }
        if (bl5) {
            Util_Logger.info(logger, "Detected source at " + this.itsSourceConfig.Hostname + " on Port " + this.itsSourceConfig.Port + " is now " + (bl3 ? "ACTIVE" : "INACTIVE") + " for monitoring");
            this.itsLastActiveStatus = bl4;
            this.itsLastActiveStatusDate = new Date();
        }
        if (bl3) {
            boolean bl6 = false;
            if (this.itsLastRunningStatus == null) {
                bl6 = true;
            } else if (bl2 != this.itsLastRunningStatus) {
                bl6 = true;
                bl = true;
            }
            if (bl6) {
                if (!this.getIsAutoActive()) {
                    Util_Logger.info(logger, "Detected source at " + this.itsSourceConfig.Hostname + " on Port " + this.itsSourceConfig.Port + " is now " + (bl2 ? "RUNNING" : "STOPPED"));
                }
                this.itsLastRunningStatus = bl2;
                this.itsLastRunningStatusDate = new Date();
            }
        }
        if (bl) {
            pdrMonitorCollectorManager.getInstance().reportCollectorStatusChange(this.itsSourceConfig.System_Id);
        }
        return bl4;
    }

    private void updateProcessStats() {
        long l = 0L;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isCurrentThreadCpuTimeSupported()) {
            l = threadMXBean.getCurrentThreadCpuTime();
        }
        this.itsCpuProcessStats = new threadMonitorCPU(l);
    }

    @Override
    public boolean getCheckIsAvailable() {
        return pdrMonitorConfigManager.getInstance().getSource((int)this.itsConfigId).InactivityTimeoutSecs > 0;
    }

    @Override
    public Date getCheckTimestamp() {
        return pdrMonitorConfigManager.getInstance().getSource((int)this.itsConfigId).LastActive;
    }

    @Override
    public int getCheckBusinessCycleSeconds() {
        return pdrMonitorConfigManager.getInstance().getSource((int)this.itsConfigId).InactivityTimeoutSecs;
    }

    @Override
    public String getCheckDescription() {
        return "pdrMonitorCollector";
    }

    @Override
    public boolean getCheckIsFatal() {
        return true;
    }

    @Override
    public void resetThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public threadMonitorStatusItem getStatusReport() {
        threadMonitorStatusItem threadMonitorStatusItem2 = new threadMonitorStatusItem("Thread " + this.itsSourceConfig.pdr_monitor_id);
        threadMonitorStatusItem2.addItem("Hostname", this.itsSourceConfig.Hostname);
        threadMonitorStatusItem2.addItem("Port", this.itsSourceConfig.Port);
        threadMonitorStatusItem2.addItem("Application", this.itsSourceConfig.App_Name);
        threadMonitorStatusItem2.addItem("Version", this.itsSourceConfig.App_Version);
        threadMonitorStatusItem2.addItem("Performance Rows", this.itsPerformanceRowsProcessed);
        threadMonitorStatusItem2.addItem("Logging Rows", this.itsLoggingRowsProcessed);
        threadMonitorStatusItem2.addItem("Status", this.getIsActive() ? "ACTIVE" : "INACTIVE");
        if (this.itsSourceConfig.LastActive != null) {
            threadMonitorStatusItem2.addItem("Last Active", Util.dateToStr(this.itsSourceConfig.LastActive, "dd/MM/yyyy HH:mm:ss"));
        }
        if (this.itsCpuProcessStats != null) {
            threadMonitorCPU threadMonitorCPU2 = this.itsCpuProcessStats;
            synchronized (threadMonitorCPU2) {
                if (this.itsCpuProcessStats.getCPUTime() > 0L) {
                    threadMonitorStatusItem2.addItem("CPU time", Long.toString(this.itsCpuProcessStats.getCPUTime()) + " " + this.itsCpuProcessStats.getCPUTimeValue());
                }
            }
        }
        return threadMonitorStatusItem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void insertData(pdrMonitorDataSet<T> pdrMonitorDataSet2, Class<T> clazz, String string) throws ApplicationException {
        Connection connection = null;
        try {
            for (T t : pdrMonitorDataSet2.getMonitorRecs()) {
                ((pdrMonitorRec)t).setPdrMonitorId(this.itsSourceConfig.pdr_monitor_id);
                ((pdrMonitorRec)t).setTransactionId(pdrMonitorDataSet2.getTransactionId());
            }
            connection = DbManager.getDbConnection();
            DbManager.insertObjects(connection, clazz, null, string, pdrMonitorDataSet2.getMonitorRecs());
            this.itsSourceConfig = pdrMonitorConfigManager.getInstance().getSource(this.itsConfigId);
            this.itsSourceConfig.LastActive = new Date();
            DbManager.updateObject(connection, pdrMonitorSource.class, null, "PDR_MONITOR_SOURCE", this.itsSourceConfig);
            connection.commit();
        }
        catch (Exception exception) {
            try {
                Util_Logger.error(logger, "Error inserting logging records: " + exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                DbManager.freeDbConnection(connection);
                throw throwable;
            }
            DbManager.freeDbConnection(connection);
        }
        DbManager.freeDbConnection(connection);
    }

    public pdrMonitorServiceStatus getServiceStatus() {
        pdrMonitorServiceStatus pdrMonitorServiceStatus2 = new pdrMonitorServiceStatus();
        pdrMonitorServiceStatus2.InstanceId = this.itsSourceConfig.Instance_Id;
        pdrMonitorServiceStatus2.PdrMonitorId = this.itsSourceConfig.pdr_monitor_id;
        pdrMonitorServiceStatus2.ServiceName = this.itsSourceConfig.App_Label;
        pdrMonitorServiceStatus2.IsRunning = this.itsLastRunningStatus == null ? false : this.itsLastRunningStatus;
        return pdrMonitorServiceStatus2;
    }

    private <T> boolean executePollCycle(String string, String string2, Class<T> clazz, String string3) {
        boolean bl;
        block20: {
            Util_Logger.info(logger, "Polling " + this.itsSourceConfig.Hostname + " for " + string + " on Port " + this.itsSourceConfig.Port);
            bl = false;
            try {
                String string4 = this.itsSourceConfig.getBaseURL() + "/api/monitor/" + string;
                this.itsWebClient.setAuthProvider(new WebClientAuthHMAC().setAPIKey(string2));
                WebHttpResponse webHttpResponse = this.itsWebClient.doGet(string4, null);
                if (webHttpResponse.ReturnCode == 200) {
                    pdrMonitorRec pdrMonitorRec2;
                    Object object2;
                    if (Util.isBlank(webHttpResponse.Body)) break block20;
                    XStream xStream = XmlUtilities.getConverter();
                    xStream.processAnnotations(pdrMonitorDataSet.class);
                    xStream.processAnnotations(clazz);
                    pdrMonitorDataSet pdrMonitorDataSet2 = (pdrMonitorDataSet)xStream.fromXML(webHttpResponse.Body);
                    Util_Logger.debug(logger, "Received Transaction ID " + pdrMonitorDataSet2.getTransactionId());
                    if (clazz == pdrPerformanceRec.class) {
                        for (Object object2 : pdrMonitorDataSet2.getMonitorRecs()) {
                            String string5;
                            Object object3;
                            pdrMonitorRec2 = (pdrPerformanceRec)object2;
                            if (Util.isBlank(((pdrPerformanceRec)pdrMonitorRec2).getConfidentiality()) && !Util.isBlank(((pdrPerformanceRec)pdrMonitorRec2).getFilename())) {
                                if (((pdrPerformanceRec)pdrMonitorRec2).getFilename().toUpperCase().startsWith("PUBLIC")) {
                                    ((pdrPerformanceRec)pdrMonitorRec2).setConfidentiality("PUBLIC");
                                } else {
                                    ((pdrPerformanceRec)pdrMonitorRec2).setConfidentiality("PRIVATE");
                                }
                            }
                            if (((pdrPerformanceRec)pdrMonitorRec2).getFileId() == null) continue;
                            pdrMonitorDataInterchangePerfSLA pdrMonitorDataInterchangePerfSLA2 = pdrMonitorConfigManager.getInstance().getPerfConfig(((pdrPerformanceRec)pdrMonitorRec2).getFileId());
                            if (((pdrPerformanceRec)pdrMonitorRec2).getFileId().endsWith("_LEGACY") && pdrMonitorDataInterchangePerfSLA2 == null) {
                                object3 = ((pdrPerformanceRec)pdrMonitorRec2).getFileId().replaceAll("_LEGACY", "");
                                pdrMonitorDataInterchangePerfSLA2 = pdrMonitorConfigManager.getInstance().getPerfConfig((String)object3);
                            }
                            if (pdrMonitorDataInterchangePerfSLA2 == null || (object3 = ((pdrPerformanceRec)pdrMonitorRec2).getFilename().split("_")) == null || ((String[])object3).length <= pdrMonitorDataInterchangePerfSLA2.IntervalItemInFilename || !Util.isInteger(string5 = object3[pdrMonitorDataInterchangePerfSLA2.IntervalItemInFilename])) continue;
                            try {
                                Date date = Util.strToDate(string5, "yyyyMMddHHmm");
                                ((pdrPerformanceRec)pdrMonitorRec2).setIntervalEndDate(date);
                            }
                            catch (Exception exception) {}
                        }
                    } else if (clazz == pdrLoggerRec.class) {
                        for (Object object2 : pdrMonitorDataSet2.getMonitorRecs()) {
                            pdrMonitorRec2 = (pdrLoggerRec)object2;
                            if (Util.isBlank(((pdrLoggerRec)pdrMonitorRec2).getMessage()) || ((pdrLoggerRec)pdrMonitorRec2).getMessage().length() <= 1000) continue;
                            ((pdrLoggerRec)pdrMonitorRec2).setMessage(((pdrLoggerRec)pdrMonitorRec2).getMessage().substring(0, 997) + "...");
                        }
                    }
                    if (!pdrMonitorDataSet2.getMonitorRecs().isEmpty()) {
                        this.insertData(pdrMonitorDataSet2, clazz, string3);
                        if (clazz == pdrPerformanceRec.class) {
                            this.itsPerformanceRowsProcessed += (long)pdrMonitorDataSet2.getMonitorRecs().size();
                            for (Object object2 : pdrMonitorDataSet2.getMonitorRecs()) {
                                pdrMonitorConfigManager.getInstance().addPerfFileEvent(this.itsConfigId, ((pdrPerformanceRec)object2).getFileId());
                            }
                        } else {
                            this.itsLoggingRowsProcessed += (long)pdrMonitorDataSet2.getMonitorRecs().size();
                        }
                        bl = true;
                    }
                    Iterator iterator = this.itsSourceConfig.getBaseURL() + "/api/monitor/receipt";
                    this.itsWebClient.setAuthProvider(new WebClientAuthHMAC().setAPIKey(string2));
                    object2 = this.itsWebClient.doPost((String)((Object)iterator), null, WebContent.MediaType.TEXT_PLAIN, pdrMonitorDataSet2.getTransactionId());
                    if (((WebHttpResponse)object2).ReturnCode == 200) {
                        Util_Logger.info(logger, "Successfully processsed TransactionId " + pdrMonitorDataSet2.getTransactionId() + " from " + string4);
                    } else {
                        Util_Logger.warning(logger, "Detected error acknowledeging TransactionId " + pdrMonitorDataSet2.getTransactionId() + " from " + string4 + ", response code is " + ((WebHttpResponse)object2).ReturnCode);
                    }
                    break block20;
                }
                Util_Logger.error(logger, "Detected error retrieving performance data from " + string4 + ", response code is " + webHttpResponse.ReturnCode);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error polling data from " + this.itsSourceConfig.Hostname + " for " + string + ": " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    @Override
    public void run() {
        Util_Logger.info(logger, "Initiated thread " + this.getId() + " collecting from host : " + this.itsSourceConfig.Hostname + " on port " + this.itsSourceConfig.Port);
        int n = 0;
        int n2 = this.itsGlobalConfig.Monitor.Polling.StandardModeSecs;
        while (this.getIsRunning()) {
            boolean bl = false;
            boolean bl2 = false;
            if (this.getIsActive() && this.getCollectorIsActive()) {
                try {
                    bl = this.executePollCycle("logger", this.itsSourceConfig.API_Key, pdrLoggerRec.class, "PDR_MONITOR_LOG_MESSAGES");
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error performing poll cycle for log data: " + exception.getMessage(), exception);
                    bl2 = true;
                }
                try {
                    bl = bl || this.executePollCycle("performance", this.itsSourceConfig.API_Key, pdrPerformanceRec.class, "PDR_MONITOR_PERFORMANCE");
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error performing poll cycle for performance data: " + exception.getMessage(), exception);
                    bl2 = true;
                }
                if (bl) {
                    if (++n >= 3 && n2 == this.itsGlobalConfig.Monitor.Polling.StandardModeSecs) {
                        n2 = this.itsGlobalConfig.Monitor.Polling.CatchupModeSecs;
                        Util_Logger.info(logger, "Entering catchup mode");
                    }
                } else {
                    n = 0;
                    if (n2 == this.itsGlobalConfig.Monitor.Polling.CatchupModeSecs) {
                        n2 = this.itsGlobalConfig.Monitor.Polling.StandardModeSecs;
                        Util_Logger.info(logger, "Leaving catchup mode");
                    }
                }
            } else {
                Util_Logger.debug(logger, "Collector thread is now inactive, skipping poll cycle");
            }
            try {
                this.updateProcessStats();
                int n3 = bl2 ? this.itsGlobalConfig.Monitor.Polling.FailWaitSecs : n2;
                Thread.sleep(n3 * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateSourceConfig();
        }
    }
}

