/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.Collectors;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Threading.threadMonitor;
import au.com.nemmco.Pdr.Monitor.Collectors.pdrMonitorCollector;
import au.com.nemmco.Pdr.Monitor.Config.ConfigWrapper;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSystem;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrMonitorCollectorManager
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(pdrMonitorCollectorManager.class);
    private ConfigWrapper itsGlobalConfig;
    private Map<Integer, pdrMonitorCollector> itsSources = new HashMap<Integer, pdrMonitorCollector>();
    private volatile boolean itsIsRunning = true;

    private pdrMonitorCollectorManager() {
    }

    public static pdrMonitorCollectorManager getInstance() {
        return SingletonHolder.instance;
    }

    public pdrMonitorCollector getHandler(int n) throws Exception {
        pdrMonitorCollector pdrMonitorCollector2 = this.itsSources.get(n);
        if (pdrMonitorCollector2 == null) {
            throw new Exception("Invalid pdrMonitor handler ID " + n);
        }
        return pdrMonitorCollector2;
    }

    public Collection<pdrMonitorCollector> getHandlers() {
        return this.itsSources.values();
    }

    public void configure(ConfigWrapper configWrapper) {
        this.itsGlobalConfig = configWrapper;
    }

    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="Intentional staged start to collector threads")
    public synchronized void startCollectors() {
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        threadMonitor threadMonitor2 = threadMonitor.getInstance();
        for (pdrMonitorSource pdrMonitorSource2 : pdrMonitorConfigManager2.getSources()) {
            Object object;
            boolean bl = false;
            try {
                object = pdrMonitorConfigManager2.getSystem(pdrMonitorSource2.System_Id);
                bl = Util.intToBoolean(((pdrMonitorSystem)object).Is_Active);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!Util.intToBoolean(pdrMonitorSource2.IsActive) || !bl || this.itsSources.containsKey(pdrMonitorSource2.pdr_monitor_id)) continue;
            object = new pdrMonitorCollector(pdrMonitorConfigManager2.getConfig(), pdrMonitorSource2.pdr_monitor_id);
            threadMonitor2.addThreadManaged((Runnable)object, ((pdrMonitorCollector)object).getName(), true);
            this.itsSources.put(((pdrMonitorCollector)object).getId(), (pdrMonitorCollector)object);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
    }

    public boolean getIsRunning() {
        return this.itsIsRunning;
    }

    public void stop() {
        this.itsIsRunning = false;
        for (pdrMonitorCollector pdrMonitorCollector2 : this.getHandlers()) {
            pdrMonitorCollector2.stop();
        }
    }

    public void reportCollectorStatusChange(String string) {
        this.checkActiveCollectors();
    }

    public synchronized void checkActiveCollectors() {
        if (this.itsIsRunning) {
            class SystemStatus {
                public String SystemId;
                public String ApplicationName;
                public int NoCollectors;
                public int NoRunningCollectors;
                public boolean IncompleteStatus;
                public Date LastRunningStatusDate;

                SystemStatus() {
                }
            }
            HashMap<Object, SystemStatus> hashMap = new HashMap<Object, SystemStatus>();
            for (pdrMonitorCollector object : this.itsSources.values()) {
                if (!object.getSystemIsActive()) continue;
                Object object2 = object.getSystem() + ":" + object.getApplication();
                SystemStatus systemStatus = (SystemStatus)hashMap.get(object2);
                if (systemStatus == null) {
                    systemStatus = new SystemStatus();
                    systemStatus.SystemId = object.getSystem();
                    systemStatus.ApplicationName = object.getApplication();
                    systemStatus.IncompleteStatus = false;
                    hashMap.put(object2, systemStatus);
                }
                if (!object.getSourceIsEnabled() || !object.getCollectorIsActive()) continue;
                ++systemStatus.NoCollectors;
                if (object.getLastRunningStatus() != null) {
                    if (object.getLastRunningStatus().booleanValue()) {
                        ++systemStatus.NoRunningCollectors;
                    }
                    if (systemStatus.LastRunningStatusDate == null) {
                        systemStatus.LastRunningStatusDate = object.getLastRunningStatusDate();
                        continue;
                    }
                    if (!object.getLastRunningStatusDate().after(systemStatus.LastRunningStatusDate)) continue;
                    systemStatus.LastRunningStatusDate = object.getLastRunningStatusDate();
                    continue;
                }
                systemStatus.IncompleteStatus = true;
            }
            boolean bl = false;
            for (Object object2 : hashMap.values()) {
                if (((SystemStatus)object2).IncompleteStatus) continue;
                if (((SystemStatus)object2).NoCollectors == 0) {
                    Util_Logger.errorNoRaise(logger, "Detected service outage on active system [" + ((SystemStatus)object2).SystemId + "] for application [" + ((SystemStatus)object2).ApplicationName + "]. No active applications are configured");
                    bl = true;
                    continue;
                }
                if (((SystemStatus)object2).NoRunningCollectors != 0) continue;
                Util_Logger.errorNoRaise(logger, "Detected service outage on active system [" + ((SystemStatus)object2).SystemId + "] for application [" + ((SystemStatus)object2).ApplicationName + "]. All [" + ((SystemStatus)object2).NoCollectors + "] application instances are stopped since " + Util.dateToStr(((SystemStatus)object2).LastRunningStatusDate, "dd/MM/yyyy HH:mm:ss"));
                bl = true;
            }
            if (!bl) {
                Util_Logger.info(logger, "No application service outages detected");
            }
        }
    }

    @Override
    public void run() {
        Util_Logger.info(logger, "Starting service management monitoring");
        while (this.getIsRunning()) {
            try {
                int n = this.itsGlobalConfig.Monitor.Polling.CollectorCheckSecs;
                Thread.sleep(n * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.checkActiveCollectors();
        }
    }

    private static class SingletonHolder {
        private static pdrMonitorCollectorManager instance = new pdrMonitorCollectorManager();

        private SingletonHolder() {
        }
    }
}

