/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.Security;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Authentication.AuthorisationProviderInt;
import au.com.aemo.Common.Authentication.IdentityRole;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSystem;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSystemGrants;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class pdrMonitorAuthorisationProvider
implements AuthorisationProviderInt {
    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="retVal variable is used")
    public List<String> resolveRole(String string, AuthorisationActionEnum authorisationActionEnum) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        pdrMonitorSystem pdrMonitorSystem2 = pdrMonitorConfigManager2.getSystem(string);
        if (pdrMonitorSystem2 != null && pdrMonitorSystem2.Grants != null) {
            for (pdrMonitorSystemGrants pdrMonitorSystemGrants2 : pdrMonitorSystem2.Grants) {
                if (authorisationActionEnum == AuthorisationActionEnum.READ) {
                    if (!pdrMonitorSystemGrants2.canView()) continue;
                    arrayList.add(pdrMonitorSystemGrants2.Role_Id);
                    continue;
                }
                if (authorisationActionEnum != AuthorisationActionEnum.WRITE || !pdrMonitorSystemGrants2.canConfigure()) continue;
                arrayList.add(pdrMonitorSystemGrants2.Role_Id);
            }
        }
        return arrayList;
    }

    @Override
    @SuppressFBWarnings(value={"UC_USELESS_OBJECT", "DM_STRING_CTOR", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public String resolveRolesToContext(String string, String string2, String string3, List<IdentityRole> list) throws Exception {
        Context context = new Context();
        context.SessionKey = string;
        context.Username = string2;
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        HashMap<String, SystemsContext> hashMap = new HashMap<String, SystemsContext>();
        for (IdentityRole object : list) {
            if (!object.getIsActive() || !object.Role_Id.equalsIgnoreCase(string3)) continue;
            context.IsAdministrator = true;
        }
        for (IdentityRole identityRole : list) {
            if (!identityRole.getIsActive()) continue;
            for (pdrMonitorSystem pdrMonitorSystem2 : pdrMonitorConfigManager2.getSystems()) {
                if (!Util.intToBoolean(pdrMonitorSystem2.Is_Active) || pdrMonitorSystem2.Grants == null) continue;
                for (pdrMonitorSystemGrants pdrMonitorSystemGrants2 : pdrMonitorSystem2.Grants) {
                    if (!pdrMonitorSystemGrants2.canView() && !pdrMonitorSystemGrants2.canConfigure() || !pdrMonitorSystemGrants2.Role_Id.equalsIgnoreCase(identityRole.Role_Id) && !context.IsAdministrator) continue;
                    SystemsContext systemsContext = (SystemsContext)hashMap.get(pdrMonitorSystemGrants2.System_Id);
                    if (systemsContext == null) {
                        systemsContext = new SystemsContext();
                        systemsContext.System_Id = new String(pdrMonitorSystemGrants2.System_Id);
                        hashMap.put(systemsContext.System_Id, systemsContext);
                    }
                    if (pdrMonitorSystemGrants2.canConfigure()) {
                        systemsContext.Can_Configure = Util.booleanToInt(true);
                    }
                    if (!pdrMonitorSystemGrants2.canView()) continue;
                    systemsContext.Can_View = Util.booleanToInt(true);
                }
            }
        }
        List<pdrMonitorSource> list2 = pdrMonitorConfigManager2.getSources();
        for (Object object : hashMap.values()) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                pdrMonitorSource pdrMonitorSource2 = (pdrMonitorSource)iterator.next();
                if (!((SystemsContext)object).System_Id.equalsIgnoreCase(pdrMonitorSource2.System_Id)) continue;
                if (pdrMonitorSource2.App_Name.equalsIgnoreCase("pdrBatcher")) {
                    ((SystemsContext)object).hasBatcher = true;
                }
                if (!pdrMonitorSource2.App_Name.equalsIgnoreCase("pdrLoader")) continue;
                ((SystemsContext)object).hasLoader = true;
            }
        }
        context.Systems = new ArrayList(hashMap.values());
        return JsonUtilities.toJson(context);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class Context {
        public String SessionKey;
        public String Username;
        public boolean IsAdministrator = false;
        public List<SystemsContext> Systems = new ArrayList<SystemsContext>();

        private Context() {
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class SystemsContext
    extends pdrMonitorSystemGrants {
        public boolean hasBatcher = false;
        public boolean hasLoader = false;

        private SystemsContext() {
        }
    }
}

