/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor;

import au.com.aemo.Common.Application.ApplicationInt;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Threading.threadMonitor;
import au.com.aemo.Common.Threading.threadMonitorCheckInt;
import au.com.aemo.Common.Threading.threadMonitorStatusItem;
import au.com.aemo.Common.Web.WebServer;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorConfig;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorManager;
import au.com.nemmco.Pdr.Monitor.Collectors.pdrMonitorCollector;
import au.com.nemmco.Pdr.Monitor.Collectors.pdrMonitorCollectorManager;
import au.com.nemmco.Pdr.Monitor.Config.ConfigWrapper;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class pdrMonitor
implements Runnable,
threadMonitorCheckInt,
ApplicationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrMonitor.class);
    public static final String CONFIGURATION_FILE = System.getProperty("config", "pdrMonitor.xml");
    public static final String APP_NAME = "pdrMonitor";
    public static final String VERSION = "1.3.1";
    private volatile boolean itsIsReady = false;

    public pdrMonitor(final ConfigWrapper configWrapper) throws Exception {
        pdrMonitorManager pdrMonitorManager2 = pdrMonitorManager.getInstance();
        pdrMonitorConfig pdrMonitorConfig2 = new pdrMonitorConfig();
        pdrMonitorConfig2.itsMaxCacheRecords = configWrapper.Monitor.LogRecordCacheSize;
        pdrMonitorConfig2.enableListener = true;
        pdrMonitorManager2.init(pdrMonitorConfig2);
        pdrMonitorManager2.setAppDetails(this);
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        pdrMonitorConfigManager2.setConfig(configWrapper);
        DbHandler dbHandler = DbManager.getDbHandler();
        Connection connection = null;
        try {
            try {
                connection = DbManager.getDbConnection();
            }
            catch (Exception exception) {
                DbManager.freeDbConnection(connection);
                Util_Logger.warning(logger, "Unable to get connection to database to validate PDR_MONITOR_* management tables exist");
                connection = null;
            }
            if (connection != null) {
                if (!dbHandler.checkTableExists(connection, null, "PDR_MONITOR_SOURCE")) {
                    throw new Exception("Detected missing PDR_MONITOR_* management tables. Please run SQL script to create management tables in database");
                }
                if (!dbHandler.checkTableExists(connection, null, "PDR_MONITOR_PERFORMANCE_FILES")) {
                    throw new Exception("Detected missing PDR_MONITOR_* management tables. Please run SQL script to update management tables in database to v1.2");
                }
                if (!dbHandler.checkColumnExists(connection, null, "PDR_MONITOR_PERFORMANCE", "MESSAGE_ID")) {
                    throw new Exception("Detected missing PDR_MONITOR_* management tables. Please run SQL script to update management tables in database to v1.3");
                }
                DbManager.freeDbConnection(connection);
            }
        }
        catch (Exception exception) {
            DbManager.freeDbConnection(connection);
            Util_Logger.error(logger, "Error validating database: " + exception.getMessage(), exception);
        }
        try {
            pdrMonitorConfigManager2.loadFromDatabase();
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error initialising monitor configuration from database: " + exception.getMessage(), exception);
        }
        WebServer webServer = WebServer.getInstance();
        if (webServer.getIsEnabled()) {
            webServer.addHandlersFromPackage("au.com.nemmco.Pdr.Monitor.API");
        }
        pdrMonitorCollectorManager pdrMonitorCollectorManager2 = pdrMonitorCollectorManager.getInstance();
        pdrMonitorCollectorManager2.configure(configWrapper);
        threadMonitor threadMonitor2 = threadMonitor.getInstance();
        threadMonitor2.addThreadManaged(pdrMonitorCollectorManager2, "SERVICE_MANAGEMENT_MONITORING", true);
        int n = 1440;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("MONITOR_DATA_PURGE");
                thread.setDaemon(true);
                return thread;
            }
        });
        scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                pdrMonitor.purgeData(configWrapper);
            }
        }, 1L, n, TimeUnit.MINUTES);
        threadMonitor2.addCheck(this);
        this.itsIsReady = true;
    }

    public boolean getIsReady() {
        return this.itsIsReady;
    }

    @Override
    public String getAppName() {
        return APP_NAME;
    }

    @Override
    public String getAppVersion() {
        return VERSION;
    }

    @Override
    public Properties getConfiguration() {
        return null;
    }

    @Override
    public void stop() {
        this.itsIsReady = false;
        pdrMonitorCollectorManager.getInstance().stop();
    }

    @Override
    public void finaliseShutdown() {
    }

    @Override
    public boolean getCheckIsAvailable() {
        return false;
    }

    @Override
    public Date getCheckTimestamp() {
        return null;
    }

    @Override
    public int getCheckBusinessCycleSeconds() {
        return 0;
    }

    @Override
    public String getCheckDescription() {
        return APP_NAME;
    }

    @Override
    public boolean getCheckIsFatal() {
        return true;
    }

    @Override
    public void resetThread() {
    }

    @Override
    public threadMonitorStatusItem getStatusReport() {
        threadMonitorStatusItem threadMonitorStatusItem2 = new threadMonitorStatusItem(APP_NAME);
        threadMonitorStatusItem threadMonitorStatusItem3 = new threadMonitorStatusItem("Threads");
        for (pdrMonitorCollector pdrMonitorCollector2 : pdrMonitorCollectorManager.getInstance().getHandlers()) {
            threadMonitorStatusItem3.addItem(pdrMonitorCollector2.getStatusReport());
        }
        threadMonitorStatusItem2.addItem(threadMonitorStatusItem3);
        return threadMonitorStatusItem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void purgeDataTable(String string, String string2, Integer n) {
        Connection connection = null;
        Statement statement = null;
        try {
            DbHandler dbHandler = DbManager.getDbHandler();
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            Date date = Util.dateOffset(new Date(), -Math.abs(n), 5);
            String string3 = "delete from " + string + " where " + string2 + " < " + dbHandler.getSqlDate(date);
            int n2 = statement.executeUpdate(string3);
            statement.close();
            connection.commit();
            Util_Logger.info(logger, "Purged " + n2 + " rows from " + string + ", retention days = " + n);
        }
        catch (Exception exception) {
            try {
                Util_Logger.errorNoRaise(logger, "Error executing data purge on " + string + ": " + exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                DbManager.freeDbConnection(connection, statement);
                throw throwable;
            }
            DbManager.freeDbConnection(connection, statement);
        }
        DbManager.freeDbConnection(connection, statement);
    }

    private static void purgeData(ConfigWrapper configWrapper) {
        if (configWrapper.Monitor != null && configWrapper.Monitor.Data != null) {
            Util_Logger.info(logger, "Starting data purge operation");
            if (configWrapper.Monitor.Data.RetentionLogDays != null) {
                pdrMonitor.purgeDataTable("PDR_MONITOR_LOG_MESSAGES", "EVENT_DATE", configWrapper.Monitor.Data.RetentionLogDays);
            }
            if (configWrapper.Monitor.Data.RetentionPerfDays != null) {
                pdrMonitor.purgeDataTable("PDR_MONITOR_PERFORMANCE", "END_DATE", configWrapper.Monitor.Data.RetentionPerfDays);
            }
            Util_Logger.info(logger, "Completed data purge operation");
        }
    }

    @Override
    public void run() {
        int n = 0;
        int n2 = 1000;
        while (this.itsIsReady) {
            if (n > 120000) {
                pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
                try {
                    pdrMonitorConfigManager2.loadFromDatabase();
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error refreshing monitor configuration from database: " + exception.getMessage(), exception);
                }
                n = 0;
            }
            try {
                Util_Logger.debug(logger, "Sleeping for " + n2 + "ms in monitor");
                Thread.sleep(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n += n2;
        }
    }
}

