/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhasedPublisher;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.sql.BFILE;
import oracle.sql.BfileDBAccess;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;

@Deprecated
public class OracleBfile
extends DatumWithConnection
implements oracle.jdbc.internal.OracleBfile {
    public static final int MAX_CHUNK_SIZE = 32512;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BfileDBAccess dbaccess;
    private long bfileLength = -1L;
    Object acProxy;
    private volatile boolean isPublishing = false;
    private final ReentrantLock publishingLock = new ReentrantLock();
    private final Condition publishingCondition = this.publishingLock.newCondition();

    public OracleBfile() {
    }

    public OracleBfile(OracleConnection conn) throws SQLException {
        this(conn, null);
    }

    public OracleBfile(OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        this.setPhysicalConnectionOf(conn);
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.dbaccess = this.getInternalConnection().createBfileDBAccess();
            if (lob_descriptor != null) {
                ((oracle.jdbc.internal.OracleConnection)conn).addBfile(this);
            }
        }
    }

    @Override
    public long length() throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            long l = this.bfileLength = this.doGetDBAccess().length(this);
            return l;
        }
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.awaitPublishing();
        if (pos < 1L || length < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
        }
        byte[] ret = null;
        if (length == 0) {
            ret = new byte[]{};
        } else {
            long num_bytes_read = 0L;
            byte[] bytes_read = new byte[length];
            num_bytes_read = this.getBytes(pos, length, bytes_read);
            if (num_bytes_read > 0L) {
                if (num_bytes_read == (long)length) {
                    ret = bytes_read;
                } else {
                    ret = new byte[(int)num_bytes_read];
                    System.arraycopy(bytes_read, 0, ret, 0, (int)num_bytes_read);
                }
            } else {
                ret = new byte[]{};
            }
        }
        return ret;
    }

    @Override
    public int getBytes(long pos, int length, byte[] buf) throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (pos < 1L || length < 0 || buf == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
            }
            int n = this.doGetDBAccess().getBytes(this, pos, length, buf);
            return n;
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            InputStream inputStream = this.doGetDBAccess().newInputStream(this, 32512, 0L);
            return inputStream;
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            long l = this.doGetDBAccess().position((oracle.jdbc.internal.OracleBfile)this, (Datum)this, pattern, start);
            return l;
        }
    }

    @Override
    public long position(BFILE pattern, long start) throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            long l = this.doGetDBAccess().position((oracle.jdbc.internal.OracleBfile)this, (Datum)this, pattern, start);
            return l;
        }
    }

    @Override
    public long position(oracle.jdbc.OracleBfile pattern, long start) throws SQLException {
        return this.position((BFILE)pattern, start);
    }

    @Override
    public String getName() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            String string = this.doGetDBAccess().getName(this);
            return string;
        }
    }

    @Override
    public String getDirAlias() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            String string = this.doGetDBAccess().getDirAlias(this);
            return string;
        }
    }

    @Override
    public void openFile() throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.doGetDBAccess().openFile(this);
        }
    }

    @Override
    public boolean isFileOpen() throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            boolean ret;
            boolean bl = ret = this.doGetDBAccess().isFileOpen(this);
            return bl;
        }
    }

    @Override
    public boolean fileExists() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            boolean bl = this.doGetDBAccess().fileExists(this);
            return bl;
        }
    }

    @Override
    public void closeFile() throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.doGetDBAccess().closeFile(this);
        }
    }

    @Override
    public byte[] getLocator() {
        return this.getBytes();
    }

    @Override
    public void setLocator(byte[] locator) {
        super.setBytes(locator);
    }

    @Override
    public InputStream getBinaryStream(long pos) throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            InputStream inputStream = this.doGetDBAccess().newInputStream(this, 32512, pos);
            return inputStream;
        }
    }

    public void open() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.doGetDBAccess().open(this, 0);
        }
    }

    @Override
    public void open(LargeObjectAccessMode mode) throws SQLException {
        this.awaitPublishing();
        this.open(mode.getCode());
    }

    public void open(int mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (mode != 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 102).fillInStackTrace();
            }
            this.doGetDBAccess().open(this, mode);
        }
    }

    @Override
    public void close() throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.doGetDBAccess().close(this);
        }
    }

    @Override
    public boolean isOpen() throws SQLException {
        this.awaitPublishing();
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            boolean bl = this.doGetDBAccess().isOpen(this);
            return bl;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        boolean ret = class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
        return ret;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            Reader reader = this.doGetDBAccess().newConversionReader(this, 8);
            return reader;
        }
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            InputStream inputStream = this.doGetDBAccess().newConversionInputStream(this, 2);
            return inputStream;
        }
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new BFILE[arraySize];
    }

    @Override
    public BfileDBAccess getDBAccess() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            BfileDBAccess bfileDBAccess = this.doGetDBAccess();
            return bfileDBAccess;
        }
    }

    private BfileDBAccess doGetDBAccess() throws SQLException {
        this.getInternalConnection().assertLockHeldByCurrentThread();
        if (this.dbaccess == null) {
            this.dbaccess = this.getInternalConnection().createBfileDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        return this.dbaccess;
    }

    @Override
    public final void setLength(long _length) {
        this.bfileLength = _length;
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    @Override
    public void setBytes(byte[] locator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public final Flow.Publisher<byte[]> publisherOracle(final long startPosition, final ErrorSet continueOnErrorSet) throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (!this.doGetDBAccess().isAsyncBfileGetSupported()) {
                throw new SQLFeatureNotSupportedException("Asynchronous publishing is not supported by " + this.getInternalConnection().getProtocolType() + " connections.");
            }
        }
        if (startPosition < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
        }
        Pipeline.requireSupportedErrorSet(continueOnErrorSet);
        this.lockBeforePublishing();
        return new PhasedPublisher<byte[]>(this.getInternalConnection().getAsyncExecutor(), this.getInternalConnection().getJoinPhaser(), this::unlockAfterPublishing){
            volatile long position;
            {
                super(executor, joinPhaser, terminalAction);
                this.position = startPosition;
            }

            @Override
            protected void requestNext(BiConsumer<byte[], Throwable> callback) {
                CompletionStageUtil.callOnComplete(OracleBfile.this.getBytesAsync(this.position, 32512, continueOnErrorSet).thenApply(nextBytes -> {
                    this.position += (long)((byte[])nextBytes).length;
                    return (byte[])(((byte[])nextBytes).length > 0 ? nextBytes : null);
                }), callback);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final CompletionStage<byte[]> getBytesAsync(long pos, int length, ErrorSet continueOnErrorSet) {
        try {
            Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();
            try {
                BfileDBAccess dbAccess;
                try {
                    dbAccess = this.doGetDBAccess();
                }
                catch (SQLException getAccessFailure) {
                    CompletionStage<byte[]> completionStage = CompletableFuture.failedStage(getAccessFailure);
                    if (lock == null) return completionStage;
                    lock.close();
                    return completionStage;
                }
                byte[] bfileBytes = new byte[length];
                CompletionStage<byte[]> completionStage = dbAccess.getBytesAsync(this, pos, length, bfileBytes, continueOnErrorSet).thenApply(bytesRead -> {
                    if (bytesRead == length) {
                        return bfileBytes;
                    }
                    byte[] endOfBfileBytes = new byte[bytesRead.intValue()];
                    System.arraycopy(bfileBytes, 0, endOfBfileBytes, 0, bytesRead);
                    return endOfBfileBytes;
                });
                return completionStage;
            }
            finally {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable;
                        throwable.addSuppressed(throwable2);
                    }
                }
            }
        }
        catch (SQLException sqlException) {
            return CompletableFuture.failedStage(sqlException);
        }
    }

    private final void lockBeforePublishing() throws SQLException {
        this.publishingLock.lock();
        this.awaitPublishing();
        try {
            this.isPublishing = true;
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    private final void awaitPublishing() throws SQLException {
        this.publishingLock.lock();
        try {
            while (this.isPublishing) {
                this.publishingCondition.await();
            }
        }
        catch (InterruptedException interrupt) {
            throw new SQLException(interrupt);
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    private final void unlockAfterPublishing() {
        this.publishingLock.lock();
        try {
            this.isPublishing = false;
            this.publishingCondition.signalAll();
        }
        finally {
            this.publishingLock.unlock();
        }
    }
}

