/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.SINT32;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeSINT32
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5465988397261455848L;
    boolean isBigEndian = false;

    protected OracleTypeSINT32(boolean isBigEndian) {
        this.isBigEndian = isBigEndian;
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        return this.toDatumInternal(value, conn);
    }

    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(obj, conn, beginIdx, count);
    }

    @Override
    public Datum toDatumInternal(Object value, OracleConnection conn) throws SQLException {
        int intValue = 0;
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            intValue = ((Number)value).intValue();
        } else if (value instanceof NUMBER) {
            NUMBER n = (NUMBER)value;
            intValue = n.intValue();
        } else {
            NUMBER n = new NUMBER(value);
            intValue = n.intValue();
        }
        return SINT32.valueOf(intValue, this.isBigEndian);
    }

    @Override
    public Datum[] toDatumArrayInternal(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (obj == null) {
            return null;
        }
        Object[] arr = (Object[])obj;
        Datum[] datumArray = SINT32.createArray(count);
        long endIdx = beginIdx + (long)count;
        int i = 0;
        while (beginIdx < endIdx) {
            datumArray[i] = this.toDatumInternal(arr[(int)beginIdx], conn);
            ++i;
            ++beginIdx;
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() {
        return 2;
    }

    @Override
    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        int out = SINT32.bytesToInt(bytes, this.isBigEndian);
        Object obj = null;
        switch (type) {
            case 1: {
                obj = new NUMBER(out);
                break;
            }
            case 2: {
                obj = new BigDecimal(out);
                break;
            }
            case 3: {
                obj = NUMBER.toBytes(out);
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
        }
        return obj;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }
}

