/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.Serializable;
import oracle.jdbc.replay.ReplayStatistics;

public class ReplayStatisticsImpl
implements oracle.jdbc.replay.internal.ReplayStatistics,
Cloneable,
Serializable {
    private long totalRequests = 0L;
    private long totalCompletedRequests = 0L;
    private long totalCalls = 0L;
    private long totalProtectedCalls = 0L;
    private long totalCallsAffectedByOutages = 0L;
    private long totalCallsTriggeringReplay = 0L;
    private long totalCallsAffectedByOutagesDuringReplay = 0L;
    private long successfulReplayCount = 0L;
    private long failedReplayCount = 0L;
    private long replayDisablingCount = 0L;
    private long totalReplayAttempts = 0L;
    private int currentRequestSize = 0;
    private static final int HISTOGRAM_SIZE = 31;
    private int[] requestSizeHistogram = new int[31];

    public ReplayStatisticsImpl() {
    }

    public ReplayStatisticsImpl(long totalRequests, long totalCompletedRequests, long totalCalls, long totalProtectedCalls, long totalCallsAffectedByOutages, long totalCallsTriggeringReplay, long totalCallsAffectedByOutagesDuringReplay, long successfulReplayCount, long failedReplayCount, long replayDisablingCount, long totalReplayAttempts, int currentRequestSize) {
        this.totalRequests = totalRequests;
        this.totalCompletedRequests = totalCompletedRequests;
        this.totalCalls = totalCalls;
        this.totalProtectedCalls = totalProtectedCalls;
        this.totalCallsAffectedByOutages = totalCallsAffectedByOutages;
        this.totalCallsTriggeringReplay = totalCallsTriggeringReplay;
        this.totalCallsAffectedByOutagesDuringReplay = totalCallsAffectedByOutagesDuringReplay;
        this.successfulReplayCount = successfulReplayCount;
        this.failedReplayCount = failedReplayCount;
        this.replayDisablingCount = replayDisablingCount;
        this.totalReplayAttempts = totalReplayAttempts;
        this.currentRequestSize = currentRequestSize;
    }

    @Override
    public long getTotalRequests() {
        return this.totalRequests;
    }

    @Override
    public long getTotalCompletedRequests() {
        return this.totalCompletedRequests;
    }

    @Override
    public long getTotalCalls() {
        return this.totalCalls;
    }

    @Override
    public long getTotalProtectedCalls() {
        return this.totalProtectedCalls;
    }

    @Override
    public long getTotalCallsAffectedByOutages() {
        return this.totalCallsAffectedByOutages;
    }

    @Override
    public long getTotalCallsTriggeringReplay() {
        return this.totalCallsTriggeringReplay;
    }

    @Override
    public long getTotalCallsAffectedByOutagesDuringReplay() {
        return this.totalCallsAffectedByOutagesDuringReplay;
    }

    @Override
    public long getSuccessfulReplayCount() {
        return this.successfulReplayCount;
    }

    @Override
    public long getFailedReplayCount() {
        return this.failedReplayCount;
    }

    @Override
    public long getReplayDisablingCount() {
        return this.replayDisablingCount;
    }

    @Override
    public long getTotalReplayAttempts() {
        return this.totalReplayAttempts;
    }

    @Override
    public int getCurrentRequestSize() {
        return this.currentRequestSize;
    }

    @Override
    public int[] getRequestSizeHistogram() {
        int[] histogram = null;
        if (this.requestSizeHistogram != null && this.requestSizeHistogram.length > 0) {
            histogram = new int[this.requestSizeHistogram.length];
            System.arraycopy(this.requestSizeHistogram, 0, histogram, 0, this.requestSizeHistogram.length);
        }
        return histogram;
    }

    void incrementTotalRequests() {
        ++this.totalRequests;
    }

    void incrementTotalCompletedRequests() {
        ++this.totalCompletedRequests;
    }

    void incrementTotalCalls() {
        ++this.totalCalls;
    }

    void incrementTotalProtectedCalls() {
        ++this.totalProtectedCalls;
    }

    void incrementTotalCallsAffectedByOutages() {
        ++this.totalCallsAffectedByOutages;
    }

    void incrementTotalCallsTriggeringReplay() {
        ++this.totalCallsTriggeringReplay;
    }

    void incrementTotalCallsAffectedByOutagesDuringReplay() {
        ++this.totalCallsAffectedByOutagesDuringReplay;
    }

    void incrementSuccessfulReplayCount() {
        ++this.successfulReplayCount;
    }

    void incrementFailedReplayCount() {
        ++this.failedReplayCount;
    }

    void incrementReplayDisablingCount() {
        ++this.replayDisablingCount;
    }

    void incrementTotalReplayAttempts() {
        ++this.totalReplayAttempts;
    }

    void incrementCurrentRequestSize() {
        ++this.currentRequestSize;
    }

    void aggregate(ReplayStatistics stats) {
        this.totalRequests += stats.getTotalRequests();
        this.totalCompletedRequests += stats.getTotalCompletedRequests();
        this.totalCalls += stats.getTotalCalls();
        this.totalProtectedCalls += stats.getTotalProtectedCalls();
        this.totalCallsAffectedByOutages += stats.getTotalCallsAffectedByOutages();
        this.totalCallsTriggeringReplay += stats.getTotalCallsTriggeringReplay();
        this.totalCallsAffectedByOutagesDuringReplay += stats.getTotalCallsAffectedByOutagesDuringReplay();
        this.successfulReplayCount += stats.getSuccessfulReplayCount();
        this.failedReplayCount += stats.getFailedReplayCount();
        this.replayDisablingCount += stats.getReplayDisablingCount();
        this.totalReplayAttempts += stats.getTotalReplayAttempts();
        this.currentRequestSize += stats.getCurrentRequestSize();
    }

    void clearCurrentRequestSize() {
        this.currentRequestSize = 0;
    }

    void updateRequestSizeHistogram(int newRequestSize) {
        if (newRequestSize > 0) {
            int index = -1;
            for (int c = newRequestSize; c > 0; c /= 2) {
                ++index;
            }
            int n = index;
            this.requestSizeHistogram[n] = this.requestSizeHistogram[n] + 1;
        }
    }

    @Override
    public void setRequestSizeHistogram(int[] newHistogram) {
        if (newHistogram != null && newHistogram.length > 0) {
            this.requestSizeHistogram = newHistogram;
        }
    }

    @Override
    public void clear() {
        this.totalRequests = 0L;
        this.totalCompletedRequests = 0L;
        this.totalCalls = 0L;
        this.totalProtectedCalls = 0L;
        this.totalCallsAffectedByOutages = 0L;
        this.totalCallsTriggeringReplay = 0L;
        this.totalCallsAffectedByOutagesDuringReplay = 0L;
        this.successfulReplayCount = 0L;
        this.failedReplayCount = 0L;
        this.replayDisablingCount = 0L;
        this.totalReplayAttempts = 0L;
        this.requestSizeHistogram = null;
    }

    public String toString() {
        return "AC Statistics:" + "\n===============================================" + "\nTotalRequests = " + this.getTotalRequests() + "\nTotalCompletedRequests = " + this.getTotalCompletedRequests() + "\nTotalCalls = " + this.getTotalCalls() + "\nTotalProtectedCalls = " + this.getTotalProtectedCalls() + "\nCurrentRequestSize = " + this.getCurrentRequestSize() + "\n===============================================" + "\nTotalCallsAffectedByOutages = " + this.getTotalCallsAffectedByOutages() + "\nTotalCallsTriggeringReplay = " + this.getTotalCallsTriggeringReplay() + "\nTotalCallsAffectedByOutagesDuringReplay = " + this.getTotalCallsAffectedByOutagesDuringReplay() + "\n===============================================" + "\nSuccessfulReplayCount = " + this.getSuccessfulReplayCount() + "\nFailedReplayCount = " + this.getFailedReplayCount() + "\nReplayDisablingCount = " + this.getReplayDisablingCount() + "\nTotalReplayAttempts = " + this.getTotalReplayAttempts() + "\n===============================================";
    }

    public String getRequestSizeHistogramString() {
        StringBuilder builder = new StringBuilder().append("AC Request-Size Histogram:").append("\n===============================================");
        if (this.requestSizeHistogram != null && this.requestSizeHistogram.length > 0) {
            int low = 1;
            int high = 0;
            for (int i = 0; i < this.requestSizeHistogram.length; ++i) {
                if (high > 0) {
                    low = high + 1;
                }
                high = low * 2 - 1;
                builder.append("\nSizes between ").append(low).append(" and ").append(high).append(" : ").append(this.requestSizeHistogram[i]);
            }
        }
        builder.append("\n===============================================");
        return builder.toString();
    }
}

