/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.AMQP;

import au.com.aemo.Common.AMQP.AMQPChannelException;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPChannelFactory
implements PooledObjectFactory<Channel> {
    private static Logger logger = LoggerFactory.getLogger(AMQPChannelFactory.class);
    private Connection connection;
    private Integer itsPrefetchCount;

    public AMQPChannelFactory(Integer n2, String string, String string2, Properties properties) {
        try {
            String string3 = Util.getProperty(properties, string2 + "amqp_uri");
            this.itsPrefetchCount = n2;
            boolean bl = Util.getProperty(properties, string2 + "amqp_ssl", "true").equalsIgnoreCase("true");
            boolean bl2 = Util.getProperty(properties, string2 + "amqp_ssl_enable_hostname_verification", "true").equalsIgnoreCase("true");
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setUri(string3);
            connectionFactory.setAutomaticRecoveryEnabled(true);
            connectionFactory.setTopologyRecoveryEnabled(true);
            if (bl) {
                SSLContext sSLContext = CertificateManager.getInstance().getSslContext();
                connectionFactory.useSslProtocol(sSLContext);
                if (bl2) {
                    connectionFactory.enableHostnameVerification();
                }
            }
            this.connection = connectionFactory.newConnection();
            this.establishBindings(string, string2, properties);
        }
        catch (Exception exception) {
            throw new AMQPChannelException("Unable to establish AMQP connection factory: " + exception.getMessage(), exception);
        }
    }

    public PooledObject<Channel> makeObject() throws Exception {
        Channel channel = this.connection.createChannel();
        if (this.itsPrefetchCount != null) {
            channel.basicQos(this.itsPrefetchCount.intValue(), true);
        }
        return new DefaultPooledObject((Object)channel);
    }

    public void destroyObject(PooledObject<Channel> pooledObject) throws Exception {
        Channel channel = (Channel)pooledObject.getObject();
        if (channel.isOpen()) {
            try {
                channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean validateObject(PooledObject<Channel> pooledObject) {
        Channel channel = (Channel)pooledObject.getObject();
        return channel.isOpen();
    }

    public void activateObject(PooledObject<Channel> pooledObject) throws Exception {
    }

    public void passivateObject(PooledObject<Channel> pooledObject) throws Exception {
    }

    private Map<String, Object> getArguements(String string, String string2, Properties properties) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string3 = Util.getProperty(properties, string + string2, null);
        if (!Util.isBlank(string3)) {
            List<String> list = Util.getList(string3, ';');
            for (String string4 : list) {
                int n2;
                if (Util.isBlank(string4) || (n2 = string4.indexOf("=")) <= 0) continue;
                String string5 = string4.substring(0, n2);
                String string6 = string4.substring(n2 + 1);
                hashMap.put(string5, string6);
            }
        }
        return hashMap;
    }

    private void establishBindings(String string, String string2, Properties properties) throws Exception {
        Util_Logger.info(logger, "Validating AMQP topology for data source [" + string + "]");
        try (Channel channel = this.connection.createChannel();){
            Object object;
            boolean bl;
            boolean bl2;
            boolean bl3;
            String string3;
            Object object2;
            Object object3;
            Object object4;
            String string4 = Util.getProperty(properties, string2 + "amqp_exchanges", null);
            if (!Util.isBlank(string4)) {
                object4 = Util.getList(string4, ',');
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    Util_Logger.info(logger, "Validating AMQP topology for exchange [" + (String)object2 + "]");
                    string3 = Util.getProperty(properties, string2 + "amqp_exchange_" + (String)object2 + "_type", "fanout");
                    bl3 = Util.getProperty(properties, string2 + "amqp_exchange_" + (String)object2 + "_create", "true").equalsIgnoreCase("true");
                    bl2 = Util.getProperty(properties, string2 + "amqp_exchange_" + (String)object2 + "_durable", "true").equalsIgnoreCase("true");
                    bl = Util.getProperty(properties, string2 + "amqp_exchange_" + (String)object2 + "_auto_delete", "false").equalsIgnoreCase("true");
                    Map<String, Object> map = this.getArguements(string2, "amqp_exchange_" + (String)object2 + "_arguements", properties);
                    if (bl3) {
                        object = channel.exchangeDeclare((String)object2, string3, bl2, bl, map);
                        continue;
                    }
                    object = channel.exchangeDeclarePassive((String)object2);
                }
            }
            if (!Util.isBlank((String)(object4 = Util.getProperty(properties, string2 + "amqp_queues", null)))) {
                object3 = Util.getList((String)object4, ',');
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    string3 = (String)object2.next();
                    Util_Logger.info(logger, "Validating AMQP topology for queue [" + string3 + "]");
                    bl3 = Util.getProperty(properties, string2 + "amqp_queue_" + string3 + "_create", "true").equalsIgnoreCase("true");
                    bl2 = Util.getProperty(properties, string2 + "amqp_queue_" + string3 + "_durable", "true").equalsIgnoreCase("true");
                    bl = Util.getProperty(properties, string2 + "amqp_queue_" + string3 + "_exclusive", "false").equalsIgnoreCase("true");
                    boolean bl4 = Util.getProperty(properties, string2 + "amqp_queue_" + string3 + "_auto_delete", "false").equalsIgnoreCase("true");
                    object = this.getArguements(string2, "amqp_queue_" + string3 + "_arguements", properties);
                    Object object5 = bl3 ? channel.queueDeclare(string3, bl2, bl, bl4, (Map)object) : channel.queueDeclarePassive(string3);
                    object5 = Util.getProperty(properties, string2 + "amqp_queue_" + string3 + "_bind_exchange", null);
                    String string5 = Util.getProperty(properties, string2 + "amqp_queue_" + string3 + "_bind_routing_key", "");
                    Map<String, Object> map = this.getArguements(string2, "amqp_queue_" + string3 + "_bind_arguements", properties);
                    if (Util.isBlank((String)object5)) continue;
                    Util_Logger.info(logger, "Binding queue [" + string3 + "] to exchange [" + (String)object5 + "]");
                    channel.queueBind(string3, (String)object5, string5, map);
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error validating AMQP topology:" + exception.getMessage(), exception);
        }
    }
}

