/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.API.PropItem;
import au.com.aemo.Common.API.PropItemCollection;
import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Files.FileMaskSpecification;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;

@WebPath(value="/api/app/configuration")
@SuppressFBWarnings(value={"DM_STRING_CTOR"}, justification="Avoid holding object references")
public class WebAPIAppConfiguration {
    @WebGET(Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getAppConfiguration() {
        Properties properties = ApplicationManager.getInstance().getConfiguration();
        Object object = Util.getProperty(properties, "config_properties_to_mask", "*PASSWORD*");
        object = !Util.isBlank((String)object) ? (String)object + ",config_properties_to_mask" : "config_properties_to_mask";
        FileMaskSpecification fileMaskSpecification = new FileMaskSpecification();
        fileMaskSpecification.setExcludeFileMask((String)object);
        PropItemCollection propItemCollection = new PropItemCollection();
        for (Object object2 : properties.keySet()) {
            PropItem propItem = new PropItem();
            propItem.Name = new String(object2.toString());
            propItem.Value = properties.getProperty(propItem.Name, null);
            if (!fileMaskSpecification.checkFileMask(propItem.Name)) continue;
            propItemCollection.properties.add(propItem);
        }
        Collections.sort(propItemCollection.properties, new Comparator<PropItem>(){

            @Override
            public int compare(PropItem propItem, PropItem propItem2) {
                return propItem.Name.compareTo(propItem2.Name);
            }
        });
        return JsonUtilities.toJson(propItemCollection);
    }
}

