/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.API.UserCredentials;
import au.com.aemo.Common.Authentication.AuthenticationManager;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Authentication.IdentitySession;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidatorTypeJSON;
import au.com.aemo.Common.Web.WebPath;
import au.com.aemo.Common.Web.WebSecurityAuthenticationEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/authentication")
public class WebAPIAuthentication {
    private static Logger logger = LoggerFactory.getLogger(WebAPIAuthentication.class);

    @WebPOST(Action=AuthorisationActionEnum.READ, Authentication=WebSecurityAuthenticationEnum.PUBLIC)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String login(@WebParam(source="_body", mandatory=true, validator=WebParamValidatorTypeJSON.class) UserCredentials userCredentials) throws Exception {
        IdentitySession identitySession = null;
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        if (authenticationManager.isEnabled()) {
            identitySession = authenticationManager.authenticateUser(userCredentials.Username, userCredentials.Password);
            if (Util.isBlank(identitySession.SessionKey)) {
                throw new Exception("Login failed");
            }
        } else {
            throw new Exception("Authentication Manager is not configured");
        }
        return JsonUtilities.toJson(identitySession);
    }

    @WebGET(AdminAccessOnly=true, Path="sessions", Action=AuthorisationActionEnum.READ, Authentication=WebSecurityAuthenticationEnum.AUTHENTICATED)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getSessions() throws Exception {
        String string = null;
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        if (!authenticationManager.isEnabled()) {
            throw new Exception("Authentication Manager is not configured");
        }
        string = JsonUtilities.listToJson(authenticationManager.getSessions());
        return string;
    }
}

