/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.API.PasswordCredentials;
import au.com.aemo.Common.Authentication.AuthenticationManager;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebAPIBaseClass;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidatorTypeJSON;
import au.com.aemo.Common.Web.WebPath;
import au.com.aemo.Common.Web.WebSecurityAuthenticationEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/authentication/passwordupdate")
public class WebAPIPasswordUpdate
extends WebAPIBaseClass {
    private static Logger logger = LoggerFactory.getLogger(WebAPIPasswordUpdate.class);

    @WebPOST(Action=AuthorisationActionEnum.READ, Authentication=WebSecurityAuthenticationEnum.AUTHENTICATED)
    @WebContent(value=WebContent.MediaType.TEXT_PLAIN)
    public String login(@WebParam(source="_body", mandatory=true, validator=WebParamValidatorTypeJSON.class) PasswordCredentials passwordCredentials) throws Exception {
        String string = null;
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        if (authenticationManager.isEnabled()) {
            try {
                string = authenticationManager.updatePassword(this.getSessionKey(), passwordCredentials.Username, passwordCredentials.OldPassword, passwordCredentials.NewPassword);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Failed to update password: " + exception.getMessage(), exception);
                string = exception.getMessage();
            }
        } else {
            throw new Exception("Authentication Manager is not configured");
        }
        return string;
    }
}

