/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Application;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Application.XProperties;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Application configuration is consumed by trusted code")
public class ConfigurationManager {
    private static Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    private Properties itsConfig;

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        return SingletonHolder.instance;
    }

    public void configure(Properties properties) {
        this.itsConfig = properties;
    }

    public void configure(String string) throws ApplicationException {
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);){
            this.itsConfig = new XProperties();
            this.itsConfig.load(inputStream);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error reading properties file " + string + ": " + exception.getMessage(), exception);
        }
    }

    public String getProperty(String string) throws IOException, ApplicationException {
        return Util.getProperty(this.itsConfig, string);
    }

    public String getProperty(String string, String string2) {
        return Util.getProperty(this.itsConfig, string, string2);
    }

    public Properties getProperties() {
        return this.itsConfig;
    }

    private static class SingletonHolder {
        private static ConfigurationManager instance = new ConfigurationManager();

        private SingletonHolder() {
        }
    }
}

