/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Authentication;

import au.com.aemo.Common.Authentication.KeyManager;
import au.com.aemo.Common.Java.Util;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class AppHMACKeyManager {
    public static void main(String[] stringArray) {
        boolean bl;
        block6: {
            bl = false;
            try {
                Object object;
                Options options = new Options();
                options.addOption("s", "show", false, "Display the web server HMAC key");
                options.addOption("c", "cycle", false, "Cycle the web server HMAC key");
                OptionGroup optionGroup = new OptionGroup();
                optionGroup.addOption(options.getOption("show"));
                optionGroup.addOption(options.getOption("cycle"));
                optionGroup.setRequired(true);
                options.addOptionGroup(optionGroup);
                DefaultParser defaultParser = new DefaultParser();
                CommandLine commandLine = null;
                try {
                    commandLine = defaultParser.parse(options, stringArray);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    object = new HelpFormatter();
                    object.printHelp("AppHMACKeyManager", options);
                    System.exit(1);
                }
                KeyManager keyManager = KeyManager.getInstance();
                keyManager.loadKeyConfiguration();
                if (commandLine.hasOption("show")) {
                    object = keyManager.getHMACKey();
                    System.out.println("Web server HMAC key is [" + (String)object + "]" + (String)(keyManager.getKeyFileLastModifiedDate() != null ? ", Last Modified : " + Util.dateToStr(keyManager.getKeyFileLastModifiedDate(), "dd/MM/yyyy HH:mm:ss") : ""));
                    bl = true;
                    break block6;
                }
                if (commandLine.hasOption("cycle")) {
                    object = keyManager.getHMACKey();
                    System.out.println("Current web server HMAC key is [" + (String)object + "]" + (String)(keyManager.getKeyFileLastModifiedDate() != null ? ", Last Modified : " + Util.dateToStr(keyManager.getKeyFileLastModifiedDate(), "dd/MM/yyyy HH:mm:ss") : ""));
                    int n2 = ((String)object).length() * 4;
                    String string = KeyManager.generateKey(n2);
                    keyManager.updateHMACKey(string);
                    String string2 = keyManager.getHMACKey();
                    System.out.println("New web server HMAC key is [" + string2 + "]");
                    System.out.println();
                    System.out.println("Please complete the following actions:");
                    System.out.println("1. Restart the application service for the new key to take effect");
                    System.out.println("2. Reconfigure any connected pdrMonitor instances with the new key to re-establish communication");
                    System.out.println("Keys can also be cycled using script pdrMonitorSourceCycleKey");
                    bl = true;
                    break block6;
                }
                throw new Exception("Selected operation is not yet supported");
            }
            catch (Exception exception) {
                System.err.println("Error in HMAC key manager:" + exception.getMessage());
                exception.printStackTrace();
            }
        }
        System.exit(bl ? 0 : 1);
    }
}

