/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Authentication;

import au.com.aemo.Common.Authentication.AuthenticationConfig;
import au.com.aemo.Common.Authentication.AuthenticationToken;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Authentication.AuthorisationProviderInt;
import au.com.aemo.Common.Authentication.IdentityPrincipal;
import au.com.aemo.Common.Authentication.IdentityProviderInt;
import au.com.aemo.Common.Authentication.IdentityRole;
import au.com.aemo.Common.Authentication.IdentitySession;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationManager {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationManager.class);
    private Map<String, AuthenticationToken> Tokens = new ConcurrentHashMap<String, AuthenticationToken>();
    private SecureRandom random = new SecureRandom();
    private int MaxTokenLifeMins;
    private int TokenExpiryMins;
    private int TokenEvictionCycleMins;
    private IdentityProviderInt IdentityProvider;
    private AuthorisationProviderInt AuthorisationProvider;
    private String AdminRole;

    private AuthenticationManager() {
    }

    public static AuthenticationManager getInstance() {
        return SingletonHolder.instance;
    }

    public void configure(AuthenticationConfig authenticationConfig) throws Exception {
        Util_Logger.info(logger, "Initialising authentication manager");
        this.MaxTokenLifeMins = authenticationConfig.MaxTokenLifeMins == null ? 1440 : authenticationConfig.MaxTokenLifeMins;
        this.TokenExpiryMins = authenticationConfig.TokenExpiryMins == null ? 60 : authenticationConfig.TokenExpiryMins;
        this.TokenEvictionCycleMins = authenticationConfig.TokenEvictionCycleMins == null ? 5 : authenticationConfig.TokenEvictionCycleMins;
        this.IdentityProvider = (IdentityProviderInt)Class.forName(authenticationConfig.IdentityProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.IdentityProvider.configure(authenticationConfig);
        this.IdentityProvider.loadData();
        this.AuthorisationProvider = (AuthorisationProviderInt)Class.forName(authenticationConfig.AuthorisationProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.AdminRole = authenticationConfig.AdminRole;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("AUTHENTICATION_TOKEN_MANAGER");
                thread.setDaemon(true);
                return thread;
            }
        });
        scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                AuthenticationManager.getInstance().expireTokens();
            }
        }, 1L, this.TokenEvictionCycleMins, TimeUnit.MINUTES);
        if (authenticationConfig.CacheExpiryTimeMins > 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                    thread.setName("IDENTITY_CACHE_MANAGER");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            scheduledExecutorService2.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    AuthenticationManager.getInstance().IdentityProvider.loadData();
                }
            }, 1L, authenticationConfig.CacheExpiryTimeMins, TimeUnit.MINUTES);
        } else {
            Util_Logger.warning(logger, "Missing Authenticaton configuration parameter CacheExpiryTimeMins, user cache will never expire");
        }
    }

    public boolean isEnabled() {
        return this.IdentityProvider != null;
    }

    private AuthenticationToken createToken(IdentityPrincipal identityPrincipal) {
        AuthenticationToken authenticationToken = new AuthenticationToken();
        authenticationToken.IssuedTo = identityPrincipal;
        authenticationToken.LastAccessed = authenticationToken.Created = new Date();
        authenticationToken.SessionKey = new BigInteger(128, this.random).toString(16).toUpperCase();
        authenticationToken.PasswordExpiryWarning = this.IdentityProvider.getPasswordExpiryWarning(identityPrincipal);
        this.Tokens.put(authenticationToken.SessionKey, authenticationToken);
        return authenticationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireTokens() {
        Util_Logger.info(logger, "Validating authentication token registry");
        ArrayList<AuthenticationToken> arrayList = new ArrayList<AuthenticationToken>();
        Date date = new Date();
        for (AuthenticationToken object : this.Tokens.values()) {
            Object object2 = Util.dateOffset(object.Created, this.MaxTokenLifeMins, 12);
            Date date2 = Util.dateOffset(object.LastAccessed, this.TokenExpiryMins, 12);
            if (date.after((Date)object2)) {
                Util_Logger.info(logger, "Expiring token [" + object.SessionKey + "] issued to user " + object.IssuedTo.User_Id + ", maximum token life exceeded");
                arrayList.add(object);
                continue;
            }
            if (!date.after(date2)) continue;
            Util_Logger.info(logger, "Expiring token [" + object.SessionKey + "] issued to user " + object.IssuedTo.User_Id + ", token inactivity");
            arrayList.add(object);
        }
        Map<String, AuthenticationToken> map = this.Tokens;
        synchronized (map) {
            for (Object object2 : arrayList) {
                this.Tokens.remove(((AuthenticationToken)object2).SessionKey);
            }
        }
    }

    public boolean validateToken(String string) throws Exception {
        boolean bl = false;
        AuthenticationToken authenticationToken = this.Tokens.get(string);
        if (authenticationToken == null) {
            throw new Exception("Invalid token");
        }
        authenticationToken.LastAccessed = new Date();
        bl = true;
        return bl;
    }

    private AuthenticationToken getTokenDetail(String string) throws Exception {
        return this.Tokens.get(string);
    }

    public String resetPassword(String string, String string2) throws Exception {
        String string3 = null;
        if (this.IdentityProvider.managesPasswords()) {
            Util_Logger.info(logger, "Resetting password for user [" + string + "]");
            string3 = this.IdentityProvider.resetPassword(string, string2);
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String updatePassword(String string, String string2, String string3, String string4) throws Exception {
        String string5 = null;
        if (!this.IdentityProvider.managesPasswords()) return string5;
        AuthenticationToken authenticationToken = this.getTokenDetail(string);
        if (authenticationToken == null) throw new Exception("Invalid session");
        if (!authenticationToken.IssuedTo.User_Id.equalsIgnoreCase(string2)) throw new Exception("Password update rejected, username does not match session");
        IdentityPrincipal identityPrincipal = this.IdentityProvider.authenticateUser(string2, string3);
        if (identityPrincipal == null) throw new Exception("Password update rejected, existing credentials are invalid");
        if (!this.IdentityProvider.checkPasswordComplexityRules(string4)) throw new Exception("Password update rejected, password does not meet complexity rules");
        try {
            return this.resetPassword(string2, string4);
        }
        catch (Exception exception) {
            throw new Exception("Password update failed due to system error");
        }
    }

    public IdentitySession authenticateUser(String string, String string2) throws Exception {
        Util_Logger.info(logger, "Received login request for user " + string);
        IdentitySession identitySession = new IdentitySession();
        try {
            IdentityPrincipal identityPrincipal = this.IdentityProvider.authenticateUser(string, string2);
            if (identityPrincipal != null) {
                AuthenticationToken authenticationToken = this.createToken(identityPrincipal);
                identitySession.SessionKey = authenticationToken.SessionKey;
                identitySession.PasswordExpiry = this.IdentityProvider.getPasswordExpiryWarning(identityPrincipal);
                Util_Logger.info(logger, "Successfully logged in user " + string + ", issued token [" + identitySession.SessionKey + "]");
            } else {
                Util_Logger.warning(logger, "Failed login attempt for user " + string);
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Error processing login attempt for user " + string + ": " + exception.getMessage(), exception);
            throw exception;
        }
        return identitySession;
    }

    public List<IdentityRole> getRoles() {
        return this.IdentityProvider.getRoles();
    }

    public String getProviderId() {
        return this.IdentityProvider.getId();
    }

    public void updateRoles(List<IdentityRole> list) throws Exception {
        int[] nArray = this.IdentityProvider.updateRoles(list);
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] > 0) {
                    Util_Logger.info(logger, "Updated role " + list.get((int)i2).Role_Id);
                    continue;
                }
                Util_Logger.info(logger, "Inserted role " + list.get((int)i2).Role_Id);
            }
        }
    }

    public List<IdentityPrincipal> getUsers() {
        return this.IdentityProvider.getUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(IdentityPrincipal identityPrincipal) throws Exception {
        if (identityPrincipal != null) {
            for (IdentityPrincipal arrayList2 : this.IdentityProvider.getUsers()) {
                if (!identityPrincipal.User_Id.equalsIgnoreCase(arrayList2.User_Id)) continue;
                identityPrincipal.CreationDate = arrayList2.CreationDate;
                identityPrincipal.PasswordChangedDate = arrayList2.PasswordChangedDate;
            }
            if (identityPrincipal.CreationDate == null) {
                identityPrincipal.CreationDate = new Date();
                if (this.IdentityProvider.managesPasswords()) {
                    identityPrincipal.PasswordChangedDate = new Date();
                }
            }
            this.IdentityProvider.createUser(identityPrincipal);
            int n2 = 0;
            if (identityPrincipal.Roles != null) {
                for (IdentityRole identityRole : identityPrincipal.Roles) {
                    if (!Util.intToBoolean(identityRole.Is_Active)) continue;
                    ++n2;
                }
            }
            Util_Logger.info(logger, "Saved user " + identityPrincipal.User_Id + " [" + (Util.intToBoolean(identityPrincipal.Is_Active) ? "Active" : "Inactive") + "] with " + n2 + " active roles");
            ArrayList<AuthenticationToken> arrayList = new ArrayList<AuthenticationToken>();
            for (AuthenticationToken authenticationToken : this.Tokens.values()) {
                if (!authenticationToken.IssuedTo.User_Id.equalsIgnoreCase(identityPrincipal.User_Id)) continue;
                arrayList.add(authenticationToken);
            }
            Map<String, AuthenticationToken> map = this.Tokens;
            synchronized (map) {
                for (AuthenticationToken authenticationToken : arrayList) {
                    this.Tokens.remove(authenticationToken.SessionKey);
                }
            }
        }
    }

    private boolean checkRoles(List<String> list, AuthenticationToken authenticationToken) {
        if (authenticationToken.IssuedTo.Roles != null) {
            for (IdentityRole identityRole : authenticationToken.IssuedTo.Roles) {
                if (list == null) continue;
                for (String string : list) {
                    if (!string.equalsIgnoreCase(identityRole.Role_Id)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkAuthorisation(String string, String string2, boolean bl, String string3, AuthorisationActionEnum authorisationActionEnum) {
        boolean bl2 = false;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!bl) {
                arrayList = this.AuthorisationProvider.resolveRole(string3, authorisationActionEnum);
            }
            arrayList.add(this.AdminRole);
            AuthenticationToken authenticationToken = this.getTokenDetail(string);
            if (authenticationToken != null && !(bl2 = this.checkRoles(arrayList, authenticationToken))) {
                Util_Logger.warning(logger, "Denied access to [" + authenticationToken.IssuedTo.User_Id + "] to resource [" + string2 + "]");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Unable to perform authorisation: " + exception.getMessage(), exception);
        }
        return bl2;
    }

    public String getdUserId(String string) throws Exception {
        AuthenticationToken authenticationToken = this.getTokenDetail(string);
        return new String(authenticationToken.IssuedTo.User_Id);
    }

    public String getAuthorisedContext(String string) throws Exception {
        AuthenticationToken authenticationToken = this.getTokenDetail(string);
        return this.AuthorisationProvider.resolveRolesToContext(string, authenticationToken.IssuedTo.User_Id, this.AdminRole, authenticationToken.IssuedTo.Roles);
    }

    public List<AuthenticationToken> getSessions() {
        ArrayList<AuthenticationToken> arrayList = null;
        if (this.Tokens != null) {
            arrayList = new ArrayList<AuthenticationToken>(this.Tokens.values());
        }
        return arrayList;
    }

    private static class SingletonHolder {
        private static AuthenticationManager instance = new AuthenticationManager();

        private SingletonHolder() {
        }
    }
}

