/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Authentication;

import au.com.aemo.Common.Authentication.AuthIdentityConfig;
import au.com.aemo.Common.Authentication.AuthenticationConfig;
import au.com.aemo.Common.Authentication.IdentityGrants;
import au.com.aemo.Common.Authentication.IdentityPrincipal;
import au.com.aemo.Common.Authentication.IdentityProviderInt;
import au.com.aemo.Common.Authentication.IdentityRole;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdentityProviderBase
implements IdentityProviderInt {
    private static Logger logger = LoggerFactory.getLogger(IdentityProviderBase.class);
    protected AuthenticationConfig authConfig;
    protected AuthIdentityConfig i;

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void configure(AuthenticationConfig authenticationConfig) throws Exception {
        this.authConfig = authenticationConfig;
        if (!Util.isBlank(this.authConfig.PasswordEncryptionKey)) {
            if (this.authConfig.PasswordEncryptionKey.length() != 32) {
                throw new Exception("Invalid parameter PasswordEncryptionKey, needs to be 32 digit hexadecimal key");
            }
            if (!Util.isHex(this.authConfig.PasswordEncryptionKey)) {
                throw new Exception("Invalid parameter PasswordEncryptionKey, needs to be 32 digit hexadecimal key");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadData() {
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            String string = "select * from " + DbManager.getDbHandler().getTableReference(this.authConfig.DbSchema, this.authConfig.DbTableUsers);
            List<IdentityPrincipal> list = DbManager.selectObjects(connection, IdentityPrincipal.class, this.authConfig.DbSchema, this.authConfig.DbTableUsers, string);
            string = "select * from " + DbManager.getDbHandler().getTableReference(this.authConfig.DbSchema, this.authConfig.DbTableRoles);
            List<IdentityRole> list2 = DbManager.selectObjects(connection, IdentityRole.class, this.authConfig.DbSchema, this.authConfig.DbTableRoles, string);
            string = "select * from " + DbManager.getDbHandler().getTableReference(this.authConfig.DbSchema, this.authConfig.DbTableUserGrants);
            List<IdentityGrants> list3 = DbManager.selectObjects(connection, IdentityGrants.class, this.authConfig.DbSchema, this.authConfig.DbTableUserGrants, string);
            AuthIdentityConfig authIdentityConfig = new AuthIdentityConfig();
            for (IdentityPrincipal object : list) {
                authIdentityConfig.Users.put(object.User_Id.toUpperCase().trim(), object);
            }
            for (IdentityGrants identityGrants : list3) {
                IdentityPrincipal identityPrincipal = authIdentityConfig.Users.get(identityGrants.User_Id.toUpperCase().trim());
                if (identityPrincipal == null) continue;
                identityPrincipal.Roles.add(identityGrants);
            }
            for (IdentityRole identityRole : list2) {
                authIdentityConfig.Roles.add(identityRole);
            }
            this.i = authIdentityConfig;
            Util_Logger.info(logger, "Loaded " + this.i.Users.size() + " users from database");
            Util_Logger.info(logger, "Loaded " + this.i.Roles.size() + " roles from database");
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error loading user data from database: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
    }

    @Override
    public List<IdentityRole> getRoles() {
        if (this.i != null) {
            return this.i.Roles;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] updateRoles(List<IdentityRole> list) throws Exception {
        Connection connection = null;
        int[] nArray = null;
        try {
            connection = DbManager.getDbConnection();
            nArray = DbManager.upsertObjects(connection, IdentityRole.class, this.authConfig.DbSchema, this.authConfig.DbTableRoles, list);
            connection.commit();
            this.loadData();
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error creating new role: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return nArray;
    }

    @Override
    public List<IdentityPrincipal> getUsers() {
        if (this.i != null) {
            return new ArrayList<IdentityPrincipal>(this.i.Users.values());
        }
        return null;
    }

    protected String createNewUserPassword(String string, String string2) throws Exception {
        return null;
    }

    @Override
    public boolean checkPasswordComplexityRules(String string) {
        return true;
    }

    @Override
    public Date getPasswordExpiryWarning(IdentityPrincipal identityPrincipal) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createUser(IdentityPrincipal identityPrincipal) throws Exception {
        if (identityPrincipal != null) {
            identityPrincipal.User_Id = identityPrincipal.User_Id.toUpperCase().trim();
            identityPrincipal.Password = this.createNewUserPassword(identityPrincipal.User_Id, identityPrincipal.Password);
            ArrayList<IdentityGrants> arrayList = new ArrayList<IdentityGrants>();
            for (IdentityRole object : identityPrincipal.Roles) {
                IdentityGrants identityGrants = new IdentityGrants();
                identityGrants.Role_Id = object.Role_Id;
                identityGrants.Is_Active = object.Is_Active;
                identityGrants.User_Id = identityPrincipal.User_Id;
                arrayList.add(identityGrants);
            }
            if (identityPrincipal.User_Id.equalsIgnoreCase("ADMIN")) {
                if (!Util.intToBoolean(identityPrincipal.Is_Active)) {
                    identityPrincipal.Is_Active = 1;
                    Util_Logger.warning(logger, "ADMIN user can not be set inactive, re-enabling ADMIN user before saving user record");
                }
                boolean bl = false;
                for (IdentityGrants identityGrants : arrayList) {
                    if (!identityGrants.Role_Id.equalsIgnoreCase(this.authConfig.AdminRole)) continue;
                    if (!Util.intToBoolean(identityGrants.Is_Active)) {
                        identityGrants.Is_Active = 1;
                        Util_Logger.warning(logger, "Role [" + this.authConfig.AdminRole + "] can not be disabled for ADMIN user, re-enabling before saving user record");
                    }
                    bl = true;
                }
                if (!bl) {
                    IdentityGrants identityGrants = new IdentityGrants();
                    identityGrants.Role_Id = this.authConfig.AdminRole;
                    identityGrants.Is_Active = 1;
                    identityGrants.User_Id = identityPrincipal.User_Id;
                    arrayList.add(identityGrants);
                    Util_Logger.warning(logger, "Role [" + this.authConfig.AdminRole + "] can not be removed from ADMIN user, adding before saving user record");
                }
            }
            Object object = null;
            try {
                object = DbManager.getDbConnection();
                DbManager.upsertObject((Connection)object, IdentityPrincipal.class, this.authConfig.DbSchema, this.authConfig.DbTableUsers, identityPrincipal);
                DbManager.upsertObjects((Connection)object, IdentityGrants.class, this.authConfig.DbSchema, this.authConfig.DbTableUserGrants, arrayList);
                object.commit();
                this.loadData();
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error creating new user: " + exception.getMessage(), exception);
            }
            finally {
                DbManager.freeDbConnection((Connection)object);
            }
        }
    }
}

