/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Authentication;

import au.com.aemo.Common.Authentication.AuthenticationConfig;
import au.com.aemo.Common.Authentication.IdentityPrincipal;
import au.com.aemo.Common.Authentication.IdentityProviderBase;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityProviderDB
extends IdentityProviderBase {
    private static Logger logger = LoggerFactory.getLogger(IdentityProviderDB.class);

    @Override
    public String getId() {
        return "LOCAL_IDENTITY_STORE";
    }

    @Override
    public boolean managesPasswords() {
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void configure(AuthenticationConfig authenticationConfig) throws Exception {
        super.configure(authenticationConfig);
        if (!Util.isBlank(this.authConfig.PasswordEncryptionKey)) {
            if (this.authConfig.PasswordEncryptionKey.length() != 32) {
                throw new Exception("Invalid parameter PasswordEncryptionKey, needs to be 32 digit hexadecimal key");
            }
            if (!Util.isHex(this.authConfig.PasswordEncryptionKey)) {
                throw new Exception("Invalid parameter PasswordEncryptionKey, needs to be 32 digit hexadecimal key");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resetPassword(String string, String string2) throws Exception {
        String string3;
        String string4 = null;
        if (Util.isBlank(string)) {
            throw new Exception("Missing Username");
        }
        if (Util.isBlank(string2)) {
            throw new Exception("Missing Password");
        }
        IdentityPrincipal identityPrincipal = this.i.Users.get(string.toUpperCase().trim());
        if (identityPrincipal == null) {
            throw new Exception("Unknown user " + string);
        }
        if (!this.checkPasswordComplexityRules(string2)) {
            throw new Exception("Password does not meet complexity rules");
        }
        identityPrincipal.Password = string3 = this.encyptPassword(string2);
        identityPrincipal.PasswordChangedDate = new Date();
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            DbManager.updateObject(connection, IdentityPrincipal.class, this.authConfig.DbSchema, this.authConfig.DbTableUsers, identityPrincipal);
            connection.commit();
            Util_Logger.info(logger, "Successfully updated password for user " + string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Successfully updated password for user ");
            stringBuilder.append(string);
            if (this.authConfig.PasswordExpiryDays != null) {
                Date date = Util.dateOffset(new Date(), this.authConfig.PasswordExpiryDays, 5);
                stringBuilder.append(", expires ");
                stringBuilder.append(Util.dateToStr(date, "dd/MM/yyyy HH:mm:ss"));
            }
            string4 = stringBuilder.toString();
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string4;
    }

    @Override
    public boolean checkPasswordComplexityRules(String string) {
        boolean bl = true;
        if (!Util.isBlank(this.authConfig.PasswordValidationRegex)) {
            bl = false;
            if (string.matches(this.authConfig.PasswordValidationRegex)) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public Date getPasswordExpiryWarning(IdentityPrincipal identityPrincipal) {
        Date date;
        Date date2;
        Date date3 = null;
        if (this.authConfig.PasswordExpiryDays != null && this.authConfig.PasswordExpiryWarningDays != null && (date2 = Util.dateOffset(date = Util.dateOffset(identityPrincipal.PasswordChangedDate, this.authConfig.PasswordExpiryDays, 5), -this.authConfig.PasswordExpiryWarningDays.intValue(), 5)).before(new Date())) {
            date3 = date;
        }
        return date3;
    }

    private String encyptPassword(String string) throws Exception {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            if (!Util.isBlank(this.authConfig.PasswordEncryptionKey)) {
                messageDigest.update(Hex.decodeHex(this.authConfig.PasswordEncryptionKey.toCharArray()));
            }
            byte[] byArray = messageDigest.digest(string.getBytes());
            string2 = Hex.encodeHexString(byArray);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error encrypting password: " + exception.getMessage(), exception);
        }
        return string2;
    }

    @Override
    public IdentityPrincipal authenticateUser(String string, String string2) {
        IdentityPrincipal identityPrincipal = null;
        try {
            IdentityPrincipal identityPrincipal2 = this.i.Users.get(string.toUpperCase().trim());
            if (identityPrincipal2 != null) {
                if (Util.intToBoolean(identityPrincipal2.Is_Active)) {
                    String string3 = this.encyptPassword(string2);
                    if (string3.equals(identityPrincipal2.Password)) {
                        if (identityPrincipal2.PasswordChangedDate != null && this.authConfig.PasswordExpiryDays != null) {
                            Date date = Util.dateOffset(identityPrincipal2.PasswordChangedDate, this.authConfig.PasswordExpiryDays, 5);
                            if (date.after(new Date())) {
                                identityPrincipal = identityPrincipal2;
                            } else {
                                Util_Logger.warning(logger, "Detected login for user [" + identityPrincipal2.User_Id + "] with expired password");
                            }
                        } else {
                            identityPrincipal = identityPrincipal2;
                        }
                    } else {
                        Util_Logger.info(logger, "Detected incorrect password for user [" + string + "]");
                    }
                } else {
                    Util_Logger.info(logger, "Detected login request for inactive user [" + string + "]");
                }
            } else {
                Util_Logger.info(logger, "Detected login request for unknown user [" + string + "]");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error processing user login: " + exception.getMessage(), exception);
        }
        return identityPrincipal;
    }

    @Override
    protected String createNewUserPassword(String string, String string2) throws Exception {
        String string3 = null;
        if (Util.isBlank(string2)) {
            IdentityPrincipal identityPrincipal = this.i.Users.get(string.toUpperCase());
            string3 = identityPrincipal.Password;
        } else {
            if (!this.checkPasswordComplexityRules(string2)) {
                throw new Exception("Password does not meet complexity rules");
            }
            string3 = this.encyptPassword(string2);
        }
        return string3;
    }
}

